/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.inventory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.opennms.core.resource.Vault;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.InventoryElement2;
import org.opennms.rancid.InventoryNode;
import org.opennms.rancid.RWSBucket;
import org.opennms.rancid.RWSClientApi;
import org.opennms.rancid.RWSResourceList;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.rancid.RancidNodeAuthentication;
import org.opennms.web.element.ElementUtil;
import org.opennms.web.inventory.InventoryWrapper;
import org.opennms.web.inventory.RancidNodeWrapper;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryService
implements InitializingBean {
    RWSConfig m_rwsConfig;
    NodeDao m_nodeDao;
    ConnectionProperties m_cp;

    public void afterPropertiesSet() throws Exception {
        RWSClientApi.init();
        this.m_cp = this.m_rwsConfig.getBase();
    }

    public RWSConfig getRwsConfig() {
        return this.m_rwsConfig;
    }

    public void setRwsConfig(RWSConfig rwsConfig) {
        this.m_rwsConfig = rwsConfig;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public boolean checkRWSAlive() {
        try {
            RWSResourceList rl = RWSClientApi.getRWSResourceServicesList((ConnectionProperties)this.m_cp);
            return rl != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkRancidNode(String deviceName) {
        InventoryService.log().debug((Object)("checkRancidNode start " + deviceName));
        try {
            RWSResourceList groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
            List grouplist = groups.getResource();
            Iterator iter1 = grouplist.iterator();
            if (iter1.hasNext()) {
                String groupname = (String)iter1.next();
                InventoryService.log().debug((Object)("checkRancidNode " + deviceName + " group " + groupname));
                try {
                    RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupname, (String)deviceName);
                    return rn != null;
                }
                catch (RancidApiException e) {
                    InventoryService.log().debug((Object)("No inventory information associated to " + deviceName));
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Map<String, Object> getRancidNodeBase(int nodeid) {
        InventoryService.log().debug((Object)("getRancidNodeBase start for nodeid: " + nodeid));
        TreeMap<String, Object> nodeModel = new TreeMap<String, Object>();
        nodeModel.put("RWSStatus", "OK");
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeid));
        String rancidName = node.getLabel();
        InventoryService.log().debug((Object)("getRancidNodeBase rancid node name: " + rancidName));
        nodeModel.put("id", rancidName);
        nodeModel.put("db_id", nodeid);
        nodeModel.put("status_general", ElementUtil.getNodeStatusString(node.getType().charAt(0)));
        nodeModel.put("url", this.m_cp.getUrl() + this.m_cp.getDirectory());
        String rancidIntegrationUseOnlyRancidAdaperProperty = Vault.getProperty((String)"opennms.rancidIntegrationUseOnlyRancidAdaper");
        InventoryService.log().debug((Object)("getRancidNodeBase opennms.rancidIntegrationUseOnlyRancidAdaper: " + rancidIntegrationUseOnlyRancidAdaperProperty));
        if (rancidIntegrationUseOnlyRancidAdaperProperty != null && "true".equalsIgnoreCase(rancidIntegrationUseOnlyRancidAdaperProperty.trim())) {
            InventoryService.log().debug((Object)"getRancidNodeBase permitModifyClogin: false");
            nodeModel.put("permitModifyClogin", false);
        } else {
            InventoryService.log().debug((Object)"getRancidNodeBase permitModifyClogin: true");
            nodeModel.put("permitModifyClogin", true);
        }
        String foreignSource = node.getForeignSource();
        if (foreignSource != null) {
            nodeModel.put("foreignSource", foreignSource);
        } else {
            nodeModel.put("foreignSource", "");
        }
        return nodeModel;
    }

    public Map<String, Object> getRancidNode(int nodeid) {
        RWSResourceList groups;
        InventoryService.log().debug((Object)"getRancidNode start");
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        ArrayList<RancidNodeWrapper> ranlist = new ArrayList<RancidNodeWrapper>();
        ArrayList bucketlist = new ArrayList();
        try {
            groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            InventoryService.log().error((Object)e.getLocalizedMessage());
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            return nodeModel;
        }
        List grouplist = groups.getResource();
        Iterator iter1 = grouplist.iterator();
        boolean first = true;
        while (iter1.hasNext()) {
            String groupname = (String)iter1.next();
            InventoryService.log().debug((Object)("getRancidNode: " + nodeid + " for group " + groupname));
            try {
                RancidNode rn;
                if (first) {
                    rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                    nodeModel.put("devicename", rn.getDeviceName());
                    nodeModel.put("status", rn.getState());
                    nodeModel.put("devicetype", rn.getDeviceType());
                    nodeModel.put("comment", rn.getComment());
                    nodeModel.put("groupname", groupname);
                    first = false;
                }
                try {
                    rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                    String vs = rn.getHeadRevision();
                    InventoryNode in = (InventoryNode)rn.getNodeVersions().get(vs);
                    RancidNodeWrapper rnw = new RancidNodeWrapper(rn.getDeviceName(), groupname, rn.getDeviceType(), rn.getComment(), rn.getHeadRevision(), rn.getTotalRevisions(), in.getCreationDate(), rn.getRootConfigurationUrl());
                    ranlist.add(rnw);
                }
                catch (RancidApiException e) {
                    InventoryService.log().debug((Object)("No configuration found for nodeid:" + nodeid + " on Group: " + groupname + " .Cause: " + e.getLocalizedMessage()));
                }
            }
            catch (RancidApiException e) {
                if (e.getRancidCode() == 2) {
                    InventoryService.log().debug((Object)("No device found in router.db for nodeid:" + nodeid + " on Group: " + groupname + " .Cause: " + e.getLocalizedMessage()));
                    continue;
                }
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                InventoryService.log().error((Object)e.getLocalizedMessage());
            }
        }
        nodeModel.put("grouptable", ranlist);
        try {
            RWSBucket bucket = RWSClientApi.getBucket((ConnectionProperties)this.m_cp, (String)rancidName);
            bucketlist.addAll(bucket.getBucketItem());
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                InventoryService.log().debug((Object)("No entry in storage for nodeid:" + nodeid + " nodeLabel: " + rancidName));
            }
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
        }
        nodeModel.put("bucketitems", bucketlist);
        return nodeModel;
    }

    public Map<String, Object> getBuckets(int nodeid) {
        InventoryService.log().debug((Object)("getBuckets start: nodeid: " + nodeid));
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        ArrayList bucketlist = new ArrayList();
        try {
            RWSBucket bucket = RWSClientApi.getBucket((ConnectionProperties)this.m_cp, (String)rancidName);
            nodeModel.put("bucketexist", true);
            bucketlist.addAll(bucket.getBucketItem());
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                nodeModel.put("bucketexist", false);
                InventoryService.log().debug((Object)("No entry in storage for nodeid:" + nodeid + " nodeLabel: " + rancidName));
            }
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
        }
        nodeModel.put("bucketlistsize", bucketlist.size());
        nodeModel.put("bucketitems", bucketlist);
        return nodeModel;
    }

    public Map<String, Object> getRancidNodeList(int nodeid) {
        RWSResourceList groups;
        InventoryService.log().debug((Object)("getRancidNodelist start: nodeid: " + nodeid));
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        try {
            groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
            return nodeModel;
        }
        ArrayList<InventoryWrapper> ranlist = new ArrayList<InventoryWrapper>();
        List grouplist = groups.getResource();
        Iterator iter2 = grouplist.iterator();
        boolean first = true;
        while (iter2.hasNext()) {
            String groupname = (String)iter2.next();
            try {
                RancidNode rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                if (first) {
                    nodeModel.put("devicename", rn.getDeviceName());
                    first = false;
                }
                RWSResourceList versionList = RWSClientApi.getRWSResourceConfigList((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                List versionListStr = versionList.getResource();
                for (String vs : versionListStr) {
                    InventoryNode in = (InventoryNode)rn.getNodeVersions().get(vs);
                    InventoryWrapper inwr = new InventoryWrapper(in.getVersionId(), in.getCreationDate(), groupname, in.getConfigurationUrl());
                    ranlist.add(inwr);
                }
            }
            catch (RancidApiException e) {
                if (e.getRancidCode() == 2) {
                    InventoryService.log().debug((Object)("No Inventory found in CVS repository for nodeid:" + nodeid + " nodeLabel: " + rancidName));
                    continue;
                }
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                InventoryService.log().error((Object)e.getLocalizedMessage());
            }
        }
        nodeModel.put("grouptable", ranlist);
        return nodeModel;
    }

    public Map<String, Object> getRancidNodeList(int nodeid, String group) {
        RWSResourceList versionList;
        RancidNode rn;
        InventoryService.log().debug((Object)("getRancidlist start: nodeid: " + nodeid + " group: " + group));
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        ArrayList<InventoryWrapper> ranlist = new ArrayList<InventoryWrapper>();
        try {
            rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)group, (String)rancidName);
            nodeModel.put("devicename", rn.getDeviceName());
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                InventoryService.log().debug((Object)("No Inventory found in CVS repository for nodeid:" + nodeid + " nodeLabel: " + rancidName));
            } else {
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                InventoryService.log().error((Object)e.getLocalizedMessage());
            }
            return nodeModel;
        }
        try {
            versionList = RWSClientApi.getRWSResourceConfigList((ConnectionProperties)this.m_cp, (String)group, (String)rancidName);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
            return nodeModel;
        }
        List versionListStr = versionList.getResource();
        for (String vs : versionListStr) {
            InventoryNode in = (InventoryNode)rn.getNodeVersions().get(vs);
            InventoryWrapper inwr = new InventoryWrapper(in.getVersionId(), in.getCreationDate(), group, in.getConfigurationUrl());
            ranlist.add(inwr);
        }
        nodeModel.put("grouptable", ranlist);
        return nodeModel;
    }

    public Map<String, Object> getInventory(int nodeid, String group, String version) {
        InventoryService.log().debug((Object)("getInventoryNode start: nodeid: " + nodeid + " group: " + group + " version: " + version));
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)group, (String)rancidName);
            InventoryNode in = (InventoryNode)rn.getNodeVersions().get(version);
            nodeModel.put("devicename", rancidName);
            nodeModel.put("groupname", group);
            nodeModel.put("version", version);
            nodeModel.put("status", in.getParent().getState());
            nodeModel.put("creationdate", in.getCreationDate());
            nodeModel.put("swconfigurationurl", in.getSoftwareImageUrl());
            nodeModel.put("configurationurl", in.getConfigurationUrl());
            InventoryService.log().debug((Object)("getInventoryNode date: " + in.getCreationDate()));
            List ie = RWSClientApi.getRWSRancidNodeInventoryElement2((ConnectionProperties)this.m_cp, (RancidNode)rn, (String)version);
            for (InventoryElement2 ietmp : ie) {
                InventoryService.log().debug((Object)("Adding inventory: " + ietmp.expand()));
            }
            nodeModel.put("inventory", ie);
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                InventoryService.log().debug((Object)("No Inventory found in CVS repository for nodeid:" + nodeid + " nodeLabel: " + rancidName));
            }
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
        }
        return nodeModel;
    }

    public Map<String, Object> getRancidNodeWithCLoginForGroup(int nodeid, String group, boolean adminRole) {
        RWSResourceList devicetypes;
        RWSResourceList groups;
        InventoryService.log().debug((Object)("getRancidNodeWithCloginFroGroup start: group: " + group));
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        try {
            groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
            return nodeModel;
        }
        List grouplist = groups.getResource();
        nodeModel.put("grouplist", grouplist);
        try {
            devicetypes = RWSClientApi.getRWSResourceDeviceTypesPatternList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
            return nodeModel;
        }
        List devicetypelist = devicetypes.getResource();
        nodeModel.put("devicetypelist", devicetypelist);
        nodeModel.put("groupname", group);
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)group, (String)rancidName);
            nodeModel.put("devicename", rn.getDeviceName());
            nodeModel.put("status", rn.getState());
            nodeModel.put("devicetype", rn.getDeviceType());
            nodeModel.put("comment", rn.getComment());
            nodeModel.put("deviceexist", true);
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                nodeModel.put("deviceexist", false);
                InventoryService.log().debug((Object)("No device found in router.db for:" + rancidName + "on Group: " + group));
            }
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
            return nodeModel;
        }
        if (adminRole) {
            InventoryService.log().debug((Object)("getRancidNode: getting clogin info for: " + rancidName));
            try {
                RancidNodeAuthentication rn5 = RWSClientApi.getRWSAuthNode((ConnectionProperties)this.m_cp, (String)rancidName);
                nodeModel.put("isadmin", "true");
                nodeModel.put("cloginuser", rn5.getUser());
                nodeModel.put("cloginpassword", rn5.getPassword());
                nodeModel.put("cloginconnmethod", rn5.getConnectionMethodString());
                nodeModel.put("cloginenablepass", rn5.getEnablePass());
                String autoen = "0";
                if (rn5.isAutoEnable()) {
                    autoen = "1";
                }
                nodeModel.put("cloginautoenable", autoen);
            }
            catch (RancidApiException e) {
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                InventoryService.log().error((Object)("getRancidNode: clogin get failed with reason: " + e.getLocalizedMessage()));
            }
        }
        return nodeModel;
    }

    public Map<String, Object> getRancidNodeWithCLogin(int nodeid, boolean adminRole) {
        RWSResourceList devicetypes;
        RWSResourceList groups;
        InventoryService.log().debug((Object)"getRancidNodeWithClogin start");
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        try {
            groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
            return nodeModel;
        }
        List grouplist = groups.getResource();
        nodeModel.put("grouplist", grouplist);
        for (String groupname : grouplist) {
            nodeModel.put("groupname", groupname);
            InventoryService.log().debug((Object)("getRancidNodeWithClogin " + rancidName + " group " + groupname));
            try {
                RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                nodeModel.put("devicename", rn.getDeviceName());
                nodeModel.put("status", rn.getState());
                nodeModel.put("devicetype", rn.getDeviceType());
                nodeModel.put("comment", rn.getComment());
                nodeModel.put("deviceexist", true);
                break;
            }
            catch (RancidApiException e) {
                if (e.getRancidCode() == 2) {
                    nodeModel.put("deviceexist", false);
                    InventoryService.log().debug((Object)("No device found in router.db for:" + rancidName + "on Group: " + groupname));
                    continue;
                }
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                InventoryService.log().error((Object)e.getLocalizedMessage());
                return nodeModel;
            }
        }
        try {
            devicetypes = RWSClientApi.getRWSResourceDeviceTypesPatternList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            InventoryService.log().error((Object)e.getLocalizedMessage());
            return nodeModel;
        }
        List devicetypelist = devicetypes.getResource();
        nodeModel.put("devicetypelist", devicetypelist);
        if (adminRole) {
            InventoryService.log().debug((Object)("getRancidNode: getting clogin info for: " + rancidName));
            try {
                RancidNodeAuthentication rn5 = RWSClientApi.getRWSAuthNode((ConnectionProperties)this.m_cp, (String)rancidName);
                nodeModel.put("isadmin", "true");
                nodeModel.put("cloginuser", rn5.getUser());
                nodeModel.put("cloginpassword", rn5.getPassword());
                nodeModel.put("cloginconnmethod", rn5.getConnectionMethodString());
                nodeModel.put("cloginenablepass", rn5.getEnablePass());
                String autoen = "0";
                if (rn5.isAutoEnable()) {
                    autoen = "1";
                }
                nodeModel.put("cloginautoenable", autoen);
            }
            catch (RancidApiException e) {
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                InventoryService.log().error((Object)("getRancidNode: clogin get failed with reason: " + e.getLocalizedMessage()));
            }
        }
        return nodeModel;
    }

    public boolean switchStatus(String groupName, String deviceName) {
        InventoryService.log().debug((Object)("InventoryService switchStatus " + groupName + "/" + deviceName));
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
            if (rn.isStateUp()) {
                InventoryService.log().debug((Object)"InventoryService switchStatus :down");
                rn.setStateUp(false);
            } else {
                InventoryService.log().debug((Object)"InventoryService switchStatus :up");
                rn.setStateUp(true);
            }
            RWSClientApi.updateRWSRancidNode((ConnectionProperties)this.m_cp, (RancidNode)rn);
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("switchStatus has given exception on node " + groupName + "/" + deviceName + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean deleteNodeOnRouterDb(String groupName, String deviceName) {
        InventoryService.log().debug((Object)("InventoryService deleteNodeOnRouterDb: " + groupName + "/" + deviceName));
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
            RWSClientApi.deleteRWSRancidNode((ConnectionProperties)this.m_cp, (RancidNode)rn);
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("deleteNodeOnRouterDb has given exception on node " + groupName + "/" + deviceName + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean updateNodeOnRouterDb(String groupName, String deviceName, String deviceType, String status, String comment) {
        InventoryService.log().debug((Object)("InventoryService updateNodeOnRouterDb: " + groupName + "->" + deviceName + ":" + deviceType + ":" + status + ":" + comment));
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
            rn.setDeviceType(deviceType);
            if (comment != null) {
                rn.setComment(comment);
            }
            if ("up".equalsIgnoreCase(status)) {
                rn.setStateUp(true);
            } else if ("down".equalsIgnoreCase(status)) {
                rn.setStateUp(false);
            }
            RWSClientApi.updateRWSRancidNode((ConnectionProperties)this.m_cp, (RancidNode)rn);
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("updateNodeOnRouterDb has given exception on node " + groupName + "/" + deviceName + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean createNodeOnRouterDb(String groupName, String deviceName, String deviceType, String status, String comment) {
        InventoryService.log().debug((Object)("InventoryService createNodeOnRouterDb: " + groupName + "->" + deviceName + ":" + deviceType + ":" + status + ":" + comment));
        try {
            RancidNode rn = new RancidNode(groupName, deviceName);
            rn.setDeviceType(deviceType);
            if (comment != null) {
                rn.setComment(comment);
            }
            if ("up".equalsIgnoreCase(status)) {
                rn.setStateUp(true);
            } else if ("down".equalsIgnoreCase(status)) {
                rn.setStateUp(false);
            }
            RWSClientApi.createRWSRancidNode((ConnectionProperties)this.m_cp, (RancidNode)rn);
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("createNodeOnRouterDb has given exception on node " + groupName + "/" + deviceName + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean updateClogin(String deviceName, String groupName, String userID, String pass, String enPass, String loginM, String autoE) {
        InventoryService.log().debug((Object)("InventoryService updateClogin for following changesuserID [" + userID + "] " + "pass [" + pass + "] " + "enpass [" + enPass + "] " + "loginM [" + loginM + "] " + "autoE [" + autoE + "] " + "groupName (ignored) [" + groupName + "] " + "deviceName [" + deviceName + "] "));
        try {
            RancidNodeAuthentication rna = RWSClientApi.getRWSAuthNode((ConnectionProperties)this.m_cp, (String)deviceName);
            rna.setUser(userID);
            rna.setPassword(pass);
            rna.setConnectionMethod(loginM);
            rna.setEnablePass(enPass);
            boolean autoeb = false;
            if (autoE.compareTo("1") == 0) {
                autoeb = true;
            }
            rna.setAutoEnable(autoeb);
            RWSClientApi.createOrUpdateRWSAuthNode((ConnectionProperties)this.m_cp, (RancidNodeAuthentication)rna);
            InventoryService.log().debug((Object)"InventoryService ModelAndView updateClogin changes submitted");
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("updateClogin has given exception on node " + deviceName + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean deleteClogin(String deviceName) {
        InventoryService.log().debug((Object)("InventoryService deleteClogin deviceName [" + deviceName + "] "));
        try {
            RancidNodeAuthentication rna = RWSClientApi.getRWSAuthNode((ConnectionProperties)this.m_cp, (String)deviceName);
            RWSClientApi.deleteRWSAuthNode((ConnectionProperties)this.m_cp, (RancidNodeAuthentication)rna);
            InventoryService.log().debug((Object)"InventoryService ModelAndView updateClogin changes submitted");
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("updateClogin has given exception on node " + deviceName + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean deleteBucketItem(String bucket, String filename) {
        InventoryService.log().debug((Object)("InventoryService deleteBucketItem for bucket/filename [" + bucket + "]/ " + "[" + filename + "]"));
        try {
            RWSClientApi.deleteBucketItem((ConnectionProperties)this.m_cp, (String)bucket, (String)filename);
            InventoryService.log().debug((Object)"InventoryService ModelAndView deleteBucketItem changes submitted");
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("deleteBucketItem has given exception on node " + bucket + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean deleteBucket(String bucket) {
        InventoryService.log().debug((Object)("InventoryService deleteBucket for bucket [" + bucket + "]/ "));
        try {
            RWSClientApi.deleteBucket((ConnectionProperties)this.m_cp, (String)bucket);
            InventoryService.log().debug((Object)"InventoryService ModelAndView deleteBucket changes submitted");
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("deleteBucket has given exception on node " + bucket + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean createBucket(String bucket) {
        InventoryService.log().debug((Object)("InventoryService createBucket for bucket [" + bucket + "]/ "));
        try {
            RWSClientApi.createBucket((ConnectionProperties)this.m_cp, (String)bucket);
            InventoryService.log().debug((Object)"InventoryService ModelAndView createBucket changes submitted");
        }
        catch (Exception e) {
            InventoryService.log().debug((Object)("createBucket has given exception on node " + bucket + " " + e.getMessage()));
            return false;
        }
        return true;
    }

    private static Logger log() {
        return Logger.getLogger((String)"Rancid");
    }
}

