/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.dao.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.dao.CastorDataAccessFailureException;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.web.svclayer.dao.ManualProvisioningDao;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManualProvisioningDao
implements ManualProvisioningDao {
    private File m_importFileDir;

    public void setImportFileDirectory(File importFileDir) {
        this.m_importFileDir = importFileDir;
        if (!this.m_importFileDir.exists() && !this.m_importFileDir.mkdirs()) {
            throw new NonTransientDataAccessResourceException("import file directory (" + this.m_importFileDir.getPath() + ") does not exist");
        }
    }

    @Override
    public Requisition get(String name) {
        this.checkGroupName(name);
        File importFile = this.getImportFile(name);
        if (!importFile.exists()) {
            return null;
        }
        if (!importFile.canRead()) {
            throw new PermissionDeniedDataAccessException("Unable to read file " + importFile, null);
        }
        return (Requisition)CastorUtils.unmarshalWithTranslatedExceptions(Requisition.class, (Resource)new FileSystemResource(importFile));
    }

    private void checkGroupName(String name) {
        Assert.hasLength((String)name, (String)"Group name must not be null or the empty string");
    }

    @Override
    public Collection<String> getProvisioningGroupNames() {
        String[] importFiles = this.m_importFileDir.list(this.getImportFilenameFilter());
        String[] groupNames = new String[importFiles.length];
        for (int i = 0; i < importFiles.length; ++i) {
            groupNames[i] = this.getGroupNameForImportFileName(importFiles[i]);
        }
        return Arrays.asList(groupNames);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void save(String groupName, Requisition group) {
        Requisition currentData;
        this.checkGroupName(groupName);
        File importFile = this.getImportFile(groupName);
        if (importFile.exists() && (currentData = this.get(groupName)).getDateStamp().compare(group.getDateStamp()) > 0) {
            throw new OptimisticLockingFailureException("Data in file " + importFile + " is newer than data to be saved!");
        }
        OutputStreamWriter w = null;
        try {
            StringWriter strWriter = new StringWriter();
            group.updateDateStamp();
            Marshaller.marshal((Object)group, (Writer)strWriter);
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(importFile), "UTF-8");
            w.write(strWriter.toString());
            if (w == null) return;
        }
        catch (IOException e) {
            try {
                throw new PermissionDeniedDataAccessException("Unable to write file " + importFile, (Throwable)e);
                catch (MarshalException e2) {
                    throw new CastorDataAccessFailureException("Unable to marshall import data to file " + importFile, (Throwable)e2);
                }
                catch (ValidationException e3) {
                    throw new CastorDataAccessFailureException("Invalid data for group " + groupName, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                if (w == null) throw throwable;
                IOUtils.closeQuietly(w);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)w);
    }

    private File getImportFile(String groupName) {
        this.checkGroupName(groupName);
        return new File(this.m_importFileDir, groupName + ".xml");
    }

    public FilenameFilter getImportFilenameFilter() {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches(".*\\.xml");
            }
        };
    }

    private String getGroupNameForImportFileName(String filename) {
        Matcher matcher = Pattern.compile("^(.*)\\.xml$").matcher(filename);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid import gorup file name " + filename + ", doesn't match form *.xml");
        }
        return matcher.group(1);
    }

    @Override
    public String getUrlForGroup(String groupName) {
        this.checkGroupName(groupName);
        File groupFile = this.getImportFile(groupName);
        try {
            return groupFile.toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to find URL for group " + groupName, e);
        }
    }

    @Override
    public void delete(String groupName) {
        File groupFile = this.getImportFile(groupName);
        groupFile.delete();
    }
}

