/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.dao.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.categories.Categories;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.categories.Catinfo;
import org.opennms.web.svclayer.dao.CategoryConfigDao;
import org.springframework.dao.DataRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCategoryConfigDao
implements CategoryConfigDao {
    public DefaultCategoryConfigDao() {
        try {
            CategoryFactory.init();
        }
        catch (MarshalException e) {
            throw new DataRetrievalFailureException("Syntax error in categories file", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new DataRetrievalFailureException("Validation error in categories file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new DataRetrievalFailureException("Unable to locate categories file", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalFailureException("Error load categories file", (Throwable)e);
        }
    }

    @Override
    public Category getCategoryByLabel(String label) {
        return CategoryFactory.getInstance().getCategory(label);
    }

    @Override
    public Collection<Category> findAll() {
        ArrayList<Category> catList = new ArrayList<Category>();
        Catinfo catInfo = CategoryFactory.getInstance().getConfig();
        List catGroupList = catInfo.getCategorygroupCollection();
        if (catGroupList != null) {
            for (Categorygroup cg : catGroupList) {
                Categories cats = cg.getCategories();
                Category[] categories = cats.getCategory();
                int i = 0;
                for (i = 0; i < categories.length; ++i) {
                    catList.add(categories[i]);
                }
            }
        }
        return catList;
    }
}

