/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.catstatus.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.web.svclayer.catstatus.model.StatusInterface;
import org.opennms.web.svclayer.catstatus.model.StatusNode;
import org.opennms.web.svclayer.catstatus.model.StatusService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryBuilder {
    private Map<Integer, StatusNode> m_nodeMap = new HashMap<Integer, StatusNode>();
    private Map<String, StatusInterface> m_nodeAndInterfaceMap = new HashMap<String, StatusInterface>();

    public CategoryBuilder addNode(int nodeId, String label) {
        if (!this.m_nodeMap.containsKey(nodeId)) {
            StatusNode m_statusnode = new StatusNode();
            m_statusnode.setLabel(label);
            this.m_nodeMap.put(nodeId, m_statusnode);
        }
        return this;
    }

    public CategoryBuilder addInterface(int nodeId, String interfaceIp, String ipAddress, String nodeLabel) {
        if (!this.m_nodeAndInterfaceMap.containsKey(this.getNodeAndInterfaceKey(nodeId, interfaceIp))) {
            this.addNode(nodeId, nodeLabel);
            StatusNode statusNode = this.m_nodeMap.get(nodeId);
            StatusInterface intf = new StatusInterface();
            intf.setIpAddress(ipAddress);
            statusNode.addIpInterface(intf);
            this.m_nodeAndInterfaceMap.put(this.getNodeAndInterfaceKey(nodeId, interfaceIp), intf);
        }
        return this;
    }

    public CategoryBuilder addOutageService(int nodeId, String interfaceIp, String ipAddress, String nodeLabel, String service) {
        StatusService statusService = new StatusService();
        this.addInterface(nodeId, interfaceIp, ipAddress, nodeLabel);
        StatusInterface intf = this.m_nodeAndInterfaceMap.get(this.getNodeAndInterfaceKey(nodeId, interfaceIp));
        statusService.setName(service);
        intf.addService(statusService);
        return this;
    }

    private String getNodeAndInterfaceKey(int nodeId, String interfaceIp) {
        return nodeId + ":" + interfaceIp;
    }

    public Collection<StatusNode> getNodes() {
        return this.m_nodeMap.values();
    }
}

