/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateStatus {
    private String m_label;
    private Integer m_totalEntityCount;
    private Set<OnmsNode> m_downNodes;
    private String m_status;
    private String m_link;
    public static final String NODES_ARE_DOWN = "Critical";
    public static final String ONE_SERVICE_DOWN = "Warning";
    public static final String ALL_NODES_UP = "Normal";

    public AggregateStatus(Collection<OnmsNode> nodes) {
        this.computeStatusValues(nodes);
    }

    public String getStatus() {
        return this.m_status;
    }

    private void setStatus(String color) {
        this.m_status = color;
    }

    public Integer getDownEntityCount() {
        return this.m_downNodes.size();
    }

    public Set<OnmsNode> getDownNodes() {
        return Collections.unmodifiableSet(this.m_downNodes);
    }

    private void setDownNodes(Set<OnmsNode> downNodes) {
        this.m_downNodes = downNodes;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public Integer getTotalEntityCount() {
        return this.m_totalEntityCount;
    }

    private void setTotalEntityCount(Integer totalEntityCount) {
        this.m_totalEntityCount = totalEntityCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_label == null ? "null" : this.m_label);
        sb.append(": ");
        sb.append(this.m_downNodes == null ? -1 : this.m_downNodes.size());
        sb.append(" down of ");
        sb.append(this.m_totalEntityCount == null ? -1 : this.m_totalEntityCount);
        sb.append(" total.");
        return sb.toString();
    }

    private void visitNodes(Collection<OnmsNode> nodes, AggregateStatusVisitor statusVisitor) {
        if (nodes == null) {
            return;
        }
        for (OnmsNode node : nodes) {
            node.visit((EntityVisitor)statusVisitor);
        }
    }

    private AggregateStatus computeStatusValues(Collection<OnmsNode> nodes) {
        AggregateStatusVisitor statusVisitor = new AggregateStatusVisitor();
        this.visitNodes(nodes, statusVisitor);
        this.setDownNodes(statusVisitor.getDownNodes());
        this.setTotalEntityCount(nodes.size());
        this.setStatus(statusVisitor.getStatus());
        return this;
    }

    public String getLink() {
        return this.m_link;
    }

    public void setLink(String link) {
        this.m_link = link;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AggregateStatusVisitor
    extends AbstractEntityVisitor {
        Set<OnmsNode> m_downNodes = new LinkedHashSet<OnmsNode>();
        String m_status = "Normal";
        boolean m_isCurrentNodeDown = true;

        AggregateStatusVisitor() {
        }

        public void visitNode(OnmsNode node) {
            this.m_isCurrentNodeDown = true;
        }

        public void visitNodeComplete(OnmsNode node) {
            if (this.m_isCurrentNodeDown) {
                this.m_downNodes.add(node);
                this.m_status = AggregateStatus.NODES_ARE_DOWN;
            }
        }

        public void visitMonitoredService(OnmsMonitoredService svc) {
            if ("A".equals(svc.getStatus()) && !svc.getCurrentOutages().isEmpty()) {
                if (AggregateStatus.ALL_NODES_UP.equals(this.m_status)) {
                    this.m_status = AggregateStatus.ONE_SERVICE_DOWN;
                }
            } else if ("A".equals(svc.getStatus())) {
                this.m_isCurrentNodeDown = false;
            }
        }

        public String getStatus() {
            return this.m_status;
        }

        public Set<OnmsNode> getDownNodes() {
            return this.m_downNodes;
        }
    }
}

