/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.services;

import java.util.Date;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.services.PollerService;
import org.opennms.web.services.ServiceException;

public class DefaultPollerService
implements PollerService {
    private EventProxy m_eventProxy;

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public void poll(OnmsMonitoredService monSvc, int pollResultId) {
        Event demandPollEvent = new Event();
        demandPollEvent.setUei("uei.opennms.org/internal/demandPollService");
        demandPollEvent.setNodeid((long)monSvc.getNodeId().intValue());
        demandPollEvent.setInterface(monSvc.getIpAddress());
        demandPollEvent.setIfIndex(monSvc.getIfIndex().intValue());
        demandPollEvent.setService(monSvc.getServiceType().getName());
        demandPollEvent.setCreationTime(EventConstants.formatToString((Date)new Date()));
        demandPollEvent.setTime(demandPollEvent.getCreationTime());
        demandPollEvent.setSource("PollerService");
        EventUtils.addParam((Event)demandPollEvent, (String)"demandPollId", (Object)pollResultId);
        this.sendEvent(demandPollEvent);
    }

    private void sendEvent(Event demandPollEvent) {
        try {
            this.m_eventProxy.send(demandPollEvent);
        }
        catch (EventProxyException e) {
            throw new ServiceException("Exception occurred sending demandPollEvent", (Exception)((Object)e));
        }
    }
}

