/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.opennms.web.outage.OutageModel;
import org.opennms.web.outage.OutageSummary;
import org.opennms.web.rss.AbstractFeed;

public class OutageFeed
extends AbstractFeed {
    public OutageFeed() {
        this.setMaxEntries(Integer.MAX_VALUE);
    }

    public OutageFeed(String feedType) {
        super(feedType);
        this.setMaxEntries(Integer.MAX_VALUE);
    }

    public SyndFeed getFeed() {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Nodes with Outages");
        feed.setDescription("OpenNMS Nodes with Outages");
        feed.setLink(this.getUrlBase() + "outage/list.htm");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            OutageModel model = new OutageModel();
            Date date = new Date();
            date.setTime(date.getTime() - 86400000L);
            OutageSummary[] summaries = model.getAllOutageSummaries(date);
            int count = 0;
            for (OutageSummary summary : summaries) {
                if (count++ != this.getMaxEntries()) {
                    String link = this.getUrlBase() + "element/node.jsp?node=" + summary.getNodeId();
                    SyndEntryImpl entry = new SyndEntryImpl();
                    entry.setPublishedDate(summary.getTimeDown());
                    if (summary.getTimeUp() == null) {
                        entry.setTitle(this.sanitizeTitle(summary.getNodeLabel()));
                        entry.setUpdatedDate(summary.getTimeDown());
                    } else {
                        entry.setTitle(this.sanitizeTitle(summary.getNodeLabel()) + " (resolved)");
                        entry.setUpdatedDate(summary.getTimeUp());
                    }
                    entry.setLink(link);
                    entries.add(entry);
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            this.log().warn("unable to get current outages", (Throwable)e);
        }
        feed.setEntries(entries);
        return feed;
    }
}

