/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.AlarmFactory;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.filter.NodeFilter;
import org.opennms.web.alarm.filter.SeverityFilter;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.rss.AbstractFeed;

public class AlarmFeed
extends AbstractFeed {
    public SyndFeed getFeed() {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Alarms");
        feed.setDescription("OpenNMS Alarms");
        feed.setLink(this.getUrlBase() + "alarm/list.htm");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            Alarm[] alarms;
            ArrayList<EqualsFilter> filters = new ArrayList<EqualsFilter>();
            if (this.getRequest().getParameter("node") != null) {
                Integer nodeId = WebSecurityUtils.safeParseInt((String)this.getRequest().getParameter("node"));
                filters.add(new NodeFilter(nodeId));
            }
            if (this.getRequest().getParameter("severity") != null) {
                String sev = this.getRequest().getParameter("severity");
                for (OnmsSeverity onmsSeverity : OnmsSeverity.values()) {
                    if (!onmsSeverity.getLabel().toLowerCase().equals(sev)) continue;
                    filters.add(new SeverityFilter(onmsSeverity));
                }
            }
            for (Alarm alarm : alarms = AlarmFactory.getAlarms(SortStyle.FIRSTEVENTTIME, AcknowledgeType.BOTH, filters.toArray(new Filter[0]), this.getMaxEntries(), -1)) {
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setPublishedDate(alarm.getFirstEventTime());
                if (alarm.getAcknowledgeTime() != null) {
                    entry.setTitle(this.sanitizeTitle(alarm.getLogMessage()) + " (acknowledged by " + alarm.getAcknowledgeUser() + ")");
                    entry.setUpdatedDate(alarm.getAcknowledgeTime());
                } else {
                    entry.setTitle(this.sanitizeTitle(alarm.getLogMessage()));
                    entry.setUpdatedDate(alarm.getFirstEventTime());
                }
                entry.setLink(this.getUrlBase() + "alarm/detail.jsp?id=" + alarm.getId());
                entries.add(entry);
            }
        }
        catch (SQLException e) {
            this.log().warn("unable to get event(s)", (Throwable)e);
        }
        feed.setEntries(entries);
        return feed;
    }
}

