/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.opennms.web.snmpinfo.SnmpInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="snmpConfig")
@Transactional
public class SnmpConfigRestService
extends OnmsRestService {
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{ipAddr}")
    public SnmpInfo getSnmpInfo(@PathParam(value="ipAddr") String ipAddr) {
        try {
            SnmpAgentConfig config = this.m_snmpPeerFactory.getAgentConfig(InetAddress.getByName(ipAddr));
            return new SnmpInfo(config);
        }
        catch (UnknownHostException e) {
            throw new WebApplicationException(Response.serverError().build());
        }
    }

    @PUT
    @Consumes(value={"application/xml"})
    @Path(value="{ipAddr}")
    public Response setSnmpInfo(@PathParam(value="ipAddr") String ipAddr, SnmpInfo snmpInfo) {
        try {
            SnmpEventInfo eventInfo = snmpInfo.createEventInfo(ipAddr);
            this.m_snmpPeerFactory.define(eventInfo);
            SnmpPeerFactory.saveCurrent();
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="{ipAddr}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateInterface(@PathParam(value="ipAddr") String ipAddress, MultivaluedMapImpl params) {
        try {
            SnmpInfo info = new SnmpInfo();
            this.setProperties(params, info);
            SnmpEventInfo eventInfo = info.createEventInfo(ipAddress);
            this.m_snmpPeerFactory.define(eventInfo);
            SnmpPeerFactory.saveCurrent();
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }
}

