/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsOutageCollection;
import org.opennms.web.outage.filter.NodeFilter;
import org.opennms.web.outage.filter.RecentOutagesFilter;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="outages")
public class OutageRestService
extends OnmsRestService {
    @Autowired
    private OutageDao m_outageDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    SecurityContext m_securityContext;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{outageId}")
    @Transactional
    public OnmsOutage getOutage(@PathParam(value="outageId") String outageId) {
        OnmsOutage result = (OnmsOutage)this.m_outageDao.get((Serializable)Integer.valueOf(outageId));
        return result;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_outageDao.countAll());
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    public OnmsOutageCollection getOutages() {
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsOutage.class);
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, false);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsOutage.class);
        return new OnmsOutageCollection((Collection)this.m_outageDao.findMatching(this.getDistinctIdCriteria(OnmsOutage.class, criteria)));
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="forNode/{nodeId}")
    public OnmsOutageCollection forNodeId(@PathParam(value="nodeId") int nodeId) {
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsOutage.class);
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, false);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsOutage.class);
        criteria.createAlias("monitoredService", "monitoredService");
        criteria.createAlias("monitoredService.ipInterface", "ipInterface");
        criteria.createAlias("monitoredService.ipInterface.node", "node");
        criteria.createAlias("monitoredService.serviceType", "serviceType");
        NodeFilter node = new NodeFilter(nodeId);
        criteria.add(node.getCriterion());
        Date d = new Date(System.currentTimeMillis() - 604800L);
        RecentOutagesFilter recent = new RecentOutagesFilter(d);
        criteria.add(recent.getCriterion());
        return new OnmsOutageCollection((Collection)this.m_outageDao.findMatching(this.getDistinctIdCriteria(OnmsOutage.class, criteria)));
    }
}

