/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterfaceList;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Transactional
public class OnmsSnmpInterfaceResource
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    UriInfo m_uriInfo;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsSnmpInterfaceList getSnmpInterfaces(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.add((Criterion)Restrictions.ne((String)"collect", (Object)"D"));
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria, 20, true);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, true);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsSnmpInterface.class);
        criteria.createCriteria("node").add((Criterion)Restrictions.eq((String)"id", (Object)node.getId()));
        OnmsSnmpInterfaceList snmpList = new OnmsSnmpInterfaceList((Collection)this.m_snmpInterfaceDao.findMatching(criteria));
        OnmsCriteria crit = new OnmsCriteria(OnmsSnmpInterface.class);
        crit.add((Criterion)Restrictions.ne((String)"collect", (Object)"D"));
        crit.createCriteria("node").add((Criterion)Restrictions.eq((String)"id", (Object)node.getId()));
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, crit, OnmsSnmpInterface.class);
        snmpList.setTotalCount(this.m_snmpInterfaceDao.countMatching(crit));
        return snmpList;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{ifIndex}")
    public OnmsEntity getSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        return node.getSnmpInterfaceWithIfIndex(ifIndex);
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, OnmsSnmpInterface snmpInterface) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addSnmpInterface: can't find node " + nodeCriteria);
        }
        if (snmpInterface == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addSnmpInterface: snmp interface object cannot be null");
        }
        this.log().debug("addSnmpInterface: adding interface " + snmpInterface);
        node.addSnmpInterface(snmpInterface);
        if (snmpInterface.getIpAddress() != null) {
            OnmsIpInterface iface = node.getIpInterfaceByIpAddress(snmpInterface.getIpAddress());
            iface.setSnmpInterface(snmpInterface);
        }
        this.m_snmpInterfaceDao.save((Object)snmpInterface);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{ifIndex}")
    public Response deleteSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex) {
        OnmsSnmpInterface snmpInterface;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: can't find node " + nodeCriteria);
        }
        if ((snmpInterface = node.getSnmpInterfaceWithIfIndex(ifIndex)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: can't find snmp interface with ifIndex " + ifIndex + " for node " + nodeCriteria);
        }
        this.log().debug("deletSnmpInterface: deleting interface with ifIndex " + ifIndex + " from node " + nodeCriteria);
        node.getSnmpInterfaces().remove(snmpInterface);
        this.m_nodeDao.saveOrUpdate((Object)node);
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{ifIndex}")
    public Response updateSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex, MultivaluedMapImpl params) {
        OnmsSnmpInterface snmpInterface;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: can't find node " + nodeCriteria);
        }
        if ((snmpInterface = node.getSnmpInterfaceWithIfIndex(ifIndex)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: can't find snmp interface with ifIndex " + ifIndex + " for node " + nodeCriteria);
        }
        this.log().debug("updateSnmpInterface: updating snmp interface " + snmpInterface);
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)snmpInterface);
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
        }
        Event e = null;
        if (params.containsKey("collect")) {
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", "OpenNMS.Webapp");
            bldr.setNode(node);
            bldr.setInterface(node.getPrimaryInterface().getIpAddress());
            e = bldr.getEvent();
        }
        this.log().debug("updateSnmpInterface: snmp interface " + snmpInterface + " updated");
        this.m_snmpInterfaceDao.saveOrUpdate((Object)snmpInterface);
        if (e != null) {
            try {
                this.m_eventProxy.send(e);
            }
            catch (EventProxyException ex) {
                return (Response)this.throwException(Response.Status.INTERNAL_SERVER_ERROR, "Exception occurred sending event: " + ex.getMessage());
            }
        }
        return Response.ok().build();
    }
}

