/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.provision.persist.StringXmlCalendarPropertyEditor;
import org.opennms.web.rest.ISO8601DateEditor;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnmsRestService {
    private List<Order> m_ordering = new ArrayList<Order>();
    private Integer m_limit = null;
    private Integer m_offset = null;

    protected void setLimitOffset(MultivaluedMap<String, String> params, OnmsCriteria criteria) {
        this.setLimitOffset(params, criteria, 10);
    }

    protected void setLimitOffset(MultivaluedMap<String, String> params, OnmsCriteria criteria, int defaultLimit) {
        this.setLimitOffset(params, criteria, defaultLimit, true);
    }

    protected void setLimitOffset(MultivaluedMap<String, String> params, OnmsCriteria criteria, int defaultLimit, boolean addImmediately) {
        Integer limit = defaultLimit;
        if (params.containsKey((Object)"limit")) {
            limit = Integer.valueOf((String)params.getFirst((Object)"limit"));
            params.remove((Object)"limit");
        }
        if (limit != null && limit != 0) {
            if (addImmediately) {
                criteria.setMaxResults(limit);
            } else {
                this.m_limit = limit;
            }
        }
        Integer offset = null;
        if (params.containsKey((Object)"offset")) {
            offset = Integer.valueOf((String)params.getFirst((Object)"offset"));
            params.remove((Object)"offset");
        }
        if (params.containsKey((Object)"start") && offset == null) {
            offset = Integer.valueOf((String)params.getFirst((Object)"start"));
            params.remove((Object)"start");
        }
        if (offset != null && offset != 0) {
            if (addImmediately) {
                criteria.setFirstResult(offset);
            } else {
                this.m_offset = offset;
            }
        }
    }

    protected void addFiltersToCriteria(MultivaluedMap<String, String> params, OnmsCriteria criteria, Class<?> objectClass) {
        com.sun.jersey.core.util.MultivaluedMapImpl paramsCopy = new com.sun.jersey.core.util.MultivaluedMapImpl();
        paramsCopy.putAll(params);
        if (paramsCopy.containsKey((Object)"query")) {
            String query = (String)paramsCopy.getFirst((Object)"query");
            criteria.add(Restrictions.sqlRestriction((String)query));
            paramsCopy.remove((Object)"query");
        }
        paramsCopy.remove((Object)"_dc");
        String matchType = "all";
        if (paramsCopy.containsKey((Object)"match")) {
            matchType = (String)paramsCopy.getFirst((Object)"match");
            paramsCopy.remove((Object)"match");
        }
        if (paramsCopy.containsKey((Object)"node.id") && !matchType.equalsIgnoreCase("any")) {
            String nodeId = (String)paramsCopy.getFirst((Object)"node.id");
            Integer id = new Integer(nodeId);
            criteria.createCriteria("node").add((Criterion)Restrictions.eq((String)"id", (Object)id));
            paramsCopy.remove((Object)"node.id");
        }
        ComparisonOperation op = ComparisonOperation.EQ;
        if (paramsCopy.containsKey((Object)"comparator")) {
            String comparatorLabel = (String)paramsCopy.getFirst((Object)"comparator");
            paramsCopy.remove((Object)"comparator");
            if (comparatorLabel.equals("equals")) {
                op = ComparisonOperation.EQ;
            } else if (comparatorLabel.equals("ilike")) {
                op = ComparisonOperation.ILIKE;
            } else if (comparatorLabel.equals("like")) {
                op = ComparisonOperation.LIKE;
            } else if (comparatorLabel.equals("gt")) {
                op = ComparisonOperation.GT;
            } else if (comparatorLabel.equals("lt")) {
                op = ComparisonOperation.LT;
            } else if (comparatorLabel.equals("ge")) {
                op = ComparisonOperation.GE;
            } else if (comparatorLabel.equals("le")) {
                op = ComparisonOperation.LE;
            } else if (comparatorLabel.equals("ne")) {
                op = ComparisonOperation.NE;
            } else if (comparatorLabel.equals("contains")) {
                op = ComparisonOperation.CONTAINS;
            }
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(objectClass);
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new ISO8601DateEditor());
        ArrayList<Object> criteriaList = new ArrayList<Object>();
        for (String string : paramsCopy.keySet()) {
            for (String stringValue : (List)paramsCopy.get((Object)string)) {
                if ("null".equals(stringValue)) {
                    criteriaList.add(Restrictions.isNull((String)string));
                    continue;
                }
                if ("notnull".equals(stringValue)) {
                    criteriaList.add(Restrictions.isNotNull((String)string));
                    continue;
                }
                Object thisValue = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(string));
                switch (op) {
                    case EQ: {
                        criteriaList.add(Restrictions.eq((String)string, (Object)thisValue));
                        break;
                    }
                    case NE: {
                        criteriaList.add(Restrictions.ne((String)string, (Object)thisValue));
                        break;
                    }
                    case ILIKE: {
                        criteriaList.add(Restrictions.ilike((String)string, (Object)thisValue));
                        break;
                    }
                    case LIKE: {
                        criteriaList.add(Restrictions.like((String)string, (Object)thisValue));
                        break;
                    }
                    case GT: {
                        criteriaList.add(Restrictions.gt((String)string, (Object)thisValue));
                        break;
                    }
                    case LT: {
                        criteriaList.add(Restrictions.lt((String)string, (Object)thisValue));
                        break;
                    }
                    case GE: {
                        criteriaList.add(Restrictions.ge((String)string, (Object)thisValue));
                        break;
                    }
                    case LE: {
                        criteriaList.add(Restrictions.le((String)string, (Object)thisValue));
                        break;
                    }
                    case CONTAINS: {
                        criteriaList.add(Restrictions.ilike((String)string, (String)stringValue, (MatchMode)MatchMode.ANYWHERE));
                    }
                }
            }
        }
        if (criteriaList.size() > 1 && matchType.equalsIgnoreCase("any")) {
            Criterion lhs = (Criterion)criteriaList.remove(0);
            Criterion criterion = (Criterion)criteriaList.remove(0);
            LogicalExpression or = Restrictions.or((Criterion)lhs, (Criterion)criterion);
            while (criteriaList.size() > 0) {
                Criterion criterion2 = (Criterion)criteriaList.remove(0);
                or = Restrictions.or((Criterion)or, (Criterion)criterion2);
            }
            criteria.add((Criterion)or);
        } else {
            for (Criterion criterion : criteriaList) {
                criteria.add(criterion);
            }
        }
    }

    protected void addOrdering(MultivaluedMap<String, String> params, OnmsCriteria criteria) {
        this.addOrdering(params, criteria, true);
    }

    protected void addOrdering(MultivaluedMap<String, String> params, OnmsCriteria criteria, boolean addImmediately) {
        if (params.containsKey((Object)"orderBy")) {
            String orderBy = (String)params.getFirst((Object)"orderBy");
            params.remove((Object)"orderBy");
            boolean orderAsc = true;
            if (params.containsKey((Object)"order")) {
                if ("desc".equalsIgnoreCase((String)params.getFirst((Object)"order"))) {
                    orderAsc = false;
                }
                params.remove((Object)"order");
            }
            Order o = orderAsc ? Order.asc((String)orderBy) : Order.desc((String)orderBy);
            if (addImmediately) {
                criteria.addOrder(o);
            }
            this.m_ordering.add(o);
        }
    }

    protected <T> T throwException(Response.Status status, String msg) {
        this.log().error(msg);
        throw new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public static String convertNameToPropertyName(String name) {
        StringBuffer result = new StringBuffer();
        boolean nextIsUpper = false;
        if (name != null && name.length() > 0) {
            if (name.length() > 1 && (name.substring(1, 2).equals("_") || name.substring(1, 2).equals("-"))) {
                result.append(name.substring(0, 1).toUpperCase());
            } else {
                result.append(name.substring(0, 1).toLowerCase());
            }
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals("_") || s.equals("-")) {
                    nextIsUpper = true;
                    continue;
                }
                if (nextIsUpper) {
                    result.append(s.toUpperCase());
                    nextIsUpper = false;
                    continue;
                }
                result.append(s.toLowerCase());
            }
        }
        return result.toString();
    }

    protected OnmsCriteria getDistinctIdCriteria(Class<?> clazz, OnmsCriteria criteria) {
        criteria.setProjection(Projections.distinct((Projection)Projections.projectionList().add(Projections.alias((Projection)Projections.property((String)"id"), (String)"id"))));
        LogUtils.infof((Object)this, (String)("**** m_offset: " + this.m_offset + " ****"), (Object[])new Object[0]);
        OnmsCriteria rootCriteria = new OnmsCriteria(clazz);
        rootCriteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)criteria.getDetachedCriteria()));
        for (Order o : this.m_ordering) {
            rootCriteria.addOrder(o);
        }
        if (this.m_limit != null) {
            rootCriteria.setMaxResults(this.m_limit);
        }
        if (this.m_offset != null) {
            rootCriteria.setFirstResult(this.m_offset);
        }
        return rootCriteria;
    }

    protected void setProperties(MultivaluedMapImpl params, Object req) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(req);
        wrapper.registerCustomEditor(XMLGregorianCalendar.class, (PropertyEditor)new StringXmlCalendarPropertyEditor());
        for (String key : params.keySet()) {
            String propertyName = OnmsRestService.convertNameToPropertyName(key);
            if (!wrapper.isWritableProperty(propertyName)) continue;
            Object value = null;
            String stringValue = params.getFirst(key);
            value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(propertyName));
            wrapper.setPropertyValue(propertyName, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ComparisonOperation {
        EQ,
        NE,
        ILIKE,
        LIKE,
        GT,
        LT,
        GE,
        LE,
        CONTAINS;

    }
}

