/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoredServiceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Transactional
public class OnmsMonitoredServiceResource
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_serviceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsMonitoredServiceList getServices(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        return new OnmsMonitoredServiceList((Collection)node.getIpInterfaceByIpAddress(ipAddress).getMonitoredServices());
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{service}")
    public OnmsMonitoredService getService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        return node.getIpInterfaceByIpAddress(ipAddress).getMonitoredServiceByServiceType(service);
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, OnmsMonitoredService service) {
        OnmsServiceType serviceType;
        OnmsIpInterface intf;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addService: can't find node " + nodeCriteria);
        }
        if ((intf = node.getIpInterfaceByIpAddress(ipAddress)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addService: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria);
        }
        if (service == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addService: service object cannot be null");
        }
        if (service.getServiceName() == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addService: service must have a name");
        }
        if ((serviceType = this.m_serviceTypeDao.findByName(service.getServiceName())) == null) {
            this.log().info("addService: creating service type " + service.getServiceName());
            serviceType = new OnmsServiceType(service.getServiceName());
            this.m_serviceTypeDao.save((Object)serviceType);
        }
        service.setServiceType(serviceType);
        service.setIpInterface(intf);
        this.log().debug("addService: adding service " + service);
        this.m_serviceDao.save((Object)service);
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/nodeGainedService");
        e.setNodeid((long)node.getId().intValue());
        e.setInterface(intf.getIpAddress());
        e.setService(service.getServiceName());
        e.setSource(this.getClass().getName());
        e.setTime(EventConstants.formatToString((Date)new Date()));
        try {
            this.m_eventProxy.send(e);
        }
        catch (EventProxyException ex) {
            this.throwException(Response.Status.BAD_REQUEST, ex.getMessage());
        }
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{service}")
    public Response updateService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String serviceName, MultivaluedMapImpl params) {
        OnmsMonitoredService service;
        OnmsIpInterface intf;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addService: can't find node " + nodeCriteria);
        }
        if ((intf = node.getIpInterfaceByIpAddress(ipAddress)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addService: can't find ip interface on " + nodeCriteria + "@" + ipAddress);
        }
        if ((service = intf.getMonitoredServiceByServiceType(serviceName)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addService: can't find service " + serviceName + " on " + nodeCriteria + "@" + ipAddress);
        }
        this.log().debug("updateService: updating service " + service);
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)service);
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
        }
        this.log().debug("updateSservice: service " + service + " updated");
        this.m_serviceDao.saveOrUpdate((Object)service);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{service}")
    public Response deleteService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String serviceName) {
        OnmsMonitoredService service;
        OnmsIpInterface intf;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteService: can't find node " + nodeCriteria);
        }
        if ((intf = node.getIpInterfaceByIpAddress(ipAddress)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteService: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria);
        }
        if ((service = intf.getMonitoredServiceByServiceType(serviceName)) == null) {
            this.throwException(Response.Status.CONFLICT, "deleteService: service " + serviceName + " not found on interface " + intf);
        }
        this.log().debug("deleteService: deleting service " + serviceName + " from node " + nodeCriteria);
        intf.getMonitoredServices().remove(service);
        this.m_ipInterfaceDao.saveOrUpdate((Object)intf);
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/serviceDeleted");
        e.setNodeid((long)node.getId().intValue());
        e.setInterface(ipAddress);
        e.setService(serviceName);
        e.setSource(this.getClass().getName());
        e.setTime(EventConstants.formatToString((Date)new Date()));
        try {
            this.m_eventProxy.send(e);
        }
        catch (EventProxyException ex) {
            this.throwException(Response.Status.BAD_REQUEST, ex.getMessage());
        }
        return Response.ok().build();
    }
}

