/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapList;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsMapElementResource;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="maps")
@Transactional
public class OnmsMapRestService
extends OnmsRestService {
    private static final int LIMIT = 10;
    @Autowired
    private OnmsMapDao m_mapDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsMapList getMaps() {
        OnmsCriteria criteria = this.getQueryFilters();
        return new OnmsMapList((Collection)this.m_mapDao.findMatching(criteria));
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{mapId}")
    public OnmsMap getMap(@PathParam(value="mapId") int mapId) {
        return (OnmsMap)this.m_mapDao.get((Serializable)Integer.valueOf(mapId));
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addMap(OnmsMap map) {
        this.log().debug("addMap: Adding map " + map);
        this.m_mapDao.save((Object)map);
        return Response.ok((Object)map).build();
    }

    @DELETE
    @Path(value="{mapId}")
    public Response deleteMap(@PathParam(value="mapId") int mapId) {
        OnmsMap map = (OnmsMap)this.m_mapDao.get((Serializable)Integer.valueOf(mapId));
        if (map == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteMap: Can't find map with id " + mapId);
        }
        this.log().debug("deleteMap: deleting map " + mapId);
        this.m_mapDao.delete((Object)map);
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{mapId}")
    public Response updateMap(@PathParam(value="mapId") int mapId, MultivaluedMapImpl params) {
        OnmsMap map = (OnmsMap)this.m_mapDao.get((Serializable)Integer.valueOf(mapId));
        if (map == null) {
            this.throwException(Response.Status.BAD_REQUEST, "updateMap: Can't find map with id " + mapId);
        }
        this.log().debug("updateMap: updating map " + map);
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)map);
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
        }
        this.log().debug("updateMap: map " + map + " updated");
        this.m_mapDao.saveOrUpdate((Object)map);
        return Response.ok((Object)map).build();
    }

    @Path(value="{mapId}/mapElements")
    public OnmsMapElementResource getMapElementResource() {
        return (OnmsMapElementResource)this.m_context.getResource(OnmsMapElementResource.class);
    }

    private OnmsCriteria getQueryFilters() {
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsMap.class);
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria, 10, false);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, false);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsMap.class);
        return this.getDistinctIdCriteria(OnmsMap.class, criteria);
    }
}

