/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.dao.OnmsMapElementDao;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElementList;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Transactional
public class OnmsMapElementResource
extends OnmsRestService {
    @Autowired
    private OnmsMapDao m_mapDao;
    @Autowired
    private OnmsMapElementDao m_mapElementDao;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    ResourceContext m_context;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsMapElementList getMapElements(@PathParam(value="mapId") int mapId) {
        this.log().debug("getMapElements: reading elements for map " + mapId);
        OnmsMap map = (OnmsMap)this.m_mapDao.get((Serializable)Integer.valueOf(mapId));
        if (map == null) {
            this.throwException(Response.Status.BAD_REQUEST, "getMapElements: can't find map " + mapId);
        }
        return new OnmsMapElementList((Collection)map.getMapElements());
    }
}

