/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpInterfaceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsMonitoredServiceResource;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Transactional
public class OnmsIpInterfaceResource
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    ResourceContext m_context;
    @Context
    UriInfo m_uriInfo;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsIpInterfaceList getIpInterfaces(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.log().debug("getIpInterfaces: reading interfaces for node " + nodeCriteria);
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria, 20, true);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, true);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsIpInterface.class);
        criteria.createCriteria("node").add((Criterion)Restrictions.eq((String)"id", (Object)node.getId()));
        OnmsIpInterfaceList interfaceList = new OnmsIpInterfaceList((Collection)this.m_ipInterfaceDao.findMatching(criteria));
        OnmsCriteria crit = new OnmsCriteria(OnmsIpInterface.class);
        crit.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        crit.createCriteria("node").add((Criterion)Restrictions.eq((String)"id", (Object)node.getId()));
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, crit, OnmsIpInterface.class);
        int count = this.m_ipInterfaceDao.countMatching(crit);
        interfaceList.setTotalCount(count);
        return interfaceList;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{ipAddress}")
    public OnmsIpInterface getIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "getIpInterface: can't find node " + nodeCriteria);
        }
        return node.getIpInterfaceByIpAddress(ipAddress);
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, OnmsIpInterface ipInterface) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addIpInterface: can't find node " + nodeCriteria);
        }
        if (ipInterface == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addIpInterface: ip interface object cannot be null");
        }
        this.log().debug("addIpInterface: adding interface " + ipInterface);
        node.addIpInterface(ipInterface);
        this.m_ipInterfaceDao.save((Object)ipInterface);
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/nodeGainedInterface");
        e.setNodeid((long)node.getId().intValue());
        e.setInterface(ipInterface.getIpAddress());
        e.setSource(this.getClass().getName());
        e.setTime(EventConstants.formatToString((Date)new Date()));
        try {
            this.m_eventProxy.send(e);
        }
        catch (EventProxyException ex) {
            this.throwException(Response.Status.BAD_REQUEST, ex.getMessage());
        }
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{ipAddress}")
    public Response updateIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, MultivaluedMapImpl params) {
        OnmsIpInterface ipInterface;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteIpInterface: can't find node " + nodeCriteria);
        }
        if ((ipInterface = node.getIpInterfaceByIpAddress(ipAddress)) == null) {
            this.throwException(Response.Status.CONFLICT, "deleteIpInterface: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria);
        }
        this.log().debug("updateIpInterface: updating ip interface " + ipInterface);
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)ipInterface);
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
        }
        this.log().debug("updateIpInterface: ip interface " + ipInterface + " updated");
        this.m_ipInterfaceDao.saveOrUpdate((Object)ipInterface);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{ipAddress}")
    public Response deleteIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        OnmsIpInterface intf;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteIpInterface: can't find node " + nodeCriteria);
        }
        if ((intf = node.getIpInterfaceByIpAddress(ipAddress)) == null) {
            this.throwException(Response.Status.CONFLICT, "deleteIpInterface: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria);
        }
        this.log().debug("deleteIpInterface: deleting interface " + ipAddress + " from node " + nodeCriteria);
        node.getIpInterfaces().remove(intf);
        this.m_nodeDao.save((Object)node);
        Event e = new Event();
        e.setUei("uei.opennms.org/nodes/interfaceDeleted");
        e.setNodeid((long)node.getId().intValue());
        e.setInterface(ipAddress);
        e.setSource(this.getClass().getName());
        e.setTime(EventConstants.formatToString((Date)new Date()));
        try {
            this.m_eventProxy.send(e);
        }
        catch (EventProxyException ex) {
            this.throwException(Response.Status.BAD_REQUEST, ex.getMessage());
        }
        return Response.ok().build();
    }

    @Path(value="{ipAddress}/services")
    public OnmsMonitoredServiceResource getServices() {
        return (OnmsMonitoredServiceResource)this.m_context.getResource(OnmsMonitoredServiceResource.class);
    }
}

