/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="categories")
@Transactional
public class OnmsCategoryResource
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private CategoryDao m_categoryDao;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsCategoryCollection getCategories(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "getCategories: Can't find node " + nodeCriteria);
        }
        return new OnmsCategoryCollection((Collection)node.getCategories());
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{categoryName}")
    public OnmsCategory getCategory(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "getCategory: Can't find node " + nodeCriteria);
        }
        return this.getCategory(node, categoryName);
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addCategory(@PathParam(value="nodeCriteria") String nodeCriteria, OnmsCategory category) {
        OnmsCategory found;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "addCategory: Can't find node " + nodeCriteria);
        }
        if ((found = this.m_categoryDao.findByName(category.getName())) == null) {
            this.log().debug("addCategory: Saving category " + category);
            this.m_categoryDao.save((Object)category);
        } else {
            category = found;
        }
        this.log().debug("addCategory: Adding category " + category + " to node " + nodeCriteria);
        node.addCategory(category);
        this.m_nodeDao.save((Object)node);
        return Response.ok().build();
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{categoryName}")
    public Response updateCategory(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName, MultivaluedMapImpl params) {
        OnmsCategory category;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "updateCategory: Can't find node " + nodeCriteria);
        }
        if ((category = this.getCategory(node, categoryName)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "updateCategory: Category " + categoryName + " not found on node " + nodeCriteria);
        }
        this.log().debug("updateCategory: updating category " + category);
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)category);
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
        }
        this.log().debug("updateCategory: category " + category + " updated");
        this.m_nodeDao.saveOrUpdate((Object)node);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{categoryName}")
    public Response deleteCaegory(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        OnmsCategory category;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteCaegory: Can't find node " + nodeCriteria);
        }
        if ((category = this.getCategory(node, categoryName)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteCaegory: Category " + categoryName + " not found on node " + nodeCriteria);
        }
        this.log().debug("deleteCaegory: deleting category " + categoryName + " from node " + nodeCriteria);
        node.getCategories().remove(category);
        this.m_nodeDao.saveOrUpdate((Object)node);
        return Response.ok().build();
    }

    private OnmsCategory getCategory(OnmsNode node, String categoryName) {
        for (OnmsCategory category : node.getCategories()) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        return null;
    }
}

