/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.NotificationDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsNotificationCollection;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="notifications")
public class NotificationRestService
extends OnmsRestService {
    @Autowired
    private NotificationDao m_notifDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    SecurityContext m_securityContext;

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{notifId}")
    @Transactional
    public OnmsNotification getNotification(@PathParam(value="eventId") String notifId) {
        OnmsNotification result = (OnmsNotification)this.m_notifDao.get((Serializable)new Integer(notifId));
        return result;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_notifDao.countAll());
    }

    @GET
    @Produces(value={"text/xml"})
    @Transactional
    public OnmsNotificationCollection getNotifications() {
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsNotification.class);
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria, 10, false);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, false);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsNotification.class);
        return new OnmsNotificationCollection((Collection)this.m_notifDao.findMatching(this.getDistinctIdCriteria(OnmsNotification.class, criteria)));
    }

    @PUT
    @Path(value="{notifId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public void updateNotification(@PathParam(value="notifId") String notifId, @FormParam(value="ack") Boolean ack) {
        OnmsNotification notif = (OnmsNotification)this.m_notifDao.get((Serializable)new Integer(notifId));
        if (ack == null) {
            throw new IllegalArgumentException("Must supply the 'ack' parameter, set to either 'true' or 'false'");
        }
        this.processNotifAck(notif, ack);
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public void updateNotifications(MultivaluedMapImpl formProperties) {
        Boolean ack = false;
        if (formProperties.containsKey("ack")) {
            ack = "true".equals(formProperties.getFirst("ack"));
            formProperties.remove("ack");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsNotification.class);
        this.setLimitOffset(formProperties, criteria, 10, true);
        this.addFiltersToCriteria(formProperties, criteria, OnmsNotification.class);
        for (OnmsNotification notif : this.m_notifDao.findMatching(criteria)) {
            this.processNotifAck(notif, ack);
        }
    }

    private void processNotifAck(OnmsNotification notif, Boolean ack) {
        if (ack.booleanValue()) {
            notif.setRespondTime(new Date());
            notif.setAnsweredBy(this.m_securityContext.getUserPrincipal().getName());
        } else {
            notif.setRespondTime(null);
            notif.setAnsweredBy(null);
        }
        this.m_notifDao.save((Object)notif);
    }
}

