/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNodeList;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.AssetRecordResource;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsCategoryResource;
import org.opennms.web.rest.OnmsIpInterfaceResource;
import org.opennms.web.rest.OnmsRestService;
import org.opennms.web.rest.OnmsSnmpInterfaceResource;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="nodes")
@Transactional
public class NodeRestService
extends OnmsRestService {
    private static final int LIMIT = 10;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsNodeList getNodes() {
        OnmsCriteria criteria = this.getQueryFilters();
        OnmsNodeList nodeList = new OnmsNodeList((Collection)this.m_nodeDao.findMatching(criteria));
        OnmsCriteria countCrit = this.getQueryFilters();
        int count = this.m_nodeDao.countMatching(countCrit);
        nodeList.setTotalCount(count);
        return nodeList;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{nodeCriteria}")
    public OnmsNode getNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        return this.m_nodeDao.get(nodeCriteria);
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addNode(OnmsNode node) {
        this.log().debug("addNode: Adding node " + node);
        this.m_nodeDao.save((Object)node);
        try {
            this.sendEvent("uei.opennms.org/nodes/nodeAdded", node.getId());
        }
        catch (EventProxyException ex) {
            this.throwException(Response.Status.BAD_REQUEST, ex.getMessage());
        }
        return Response.ok((Object)node).build();
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{nodeCriteria}")
    public Response updateNode(@PathParam(value="nodeCriteria") String nodeCriteria, MultivaluedMapImpl params) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "updateNode: Can't find node " + nodeCriteria);
        }
        this.log().debug("updateNode: updating node " + node);
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)node);
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
        }
        this.log().debug("updateNode: node " + node + " updated");
        this.m_nodeDao.saveOrUpdate((Object)node);
        return Response.ok((Object)node).build();
    }

    @DELETE
    @Path(value="{nodeCriteria}")
    public Response deleteNode(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "deleteNode: Can't find node " + nodeCriteria);
        }
        this.log().debug("deleteNode: deleting node " + nodeCriteria);
        this.m_nodeDao.delete((Object)node);
        try {
            this.sendEvent("uei.opennms.org/nodes/nodeDeleted", node.getId());
        }
        catch (EventProxyException ex) {
            this.throwException(Response.Status.BAD_REQUEST, ex.getMessage());
        }
        return Response.ok().build();
    }

    @Path(value="{nodeCriteria}/ipinterfaces")
    public OnmsIpInterfaceResource getIpInterfaceResource() {
        return (OnmsIpInterfaceResource)this.m_context.getResource(OnmsIpInterfaceResource.class);
    }

    @Path(value="{nodeCriteria}/snmpinterfaces")
    public OnmsSnmpInterfaceResource getSnmpInterfaceResource() {
        return (OnmsSnmpInterfaceResource)this.m_context.getResource(OnmsSnmpInterfaceResource.class);
    }

    @Path(value="{nodeCriteria}/categories")
    public OnmsCategoryResource getCategoryResource() {
        return (OnmsCategoryResource)this.m_context.getResource(OnmsCategoryResource.class);
    }

    @Path(value="{nodeCriteria}/assetRecord")
    public AssetRecordResource getAssetRecordResource() {
        return (AssetRecordResource)this.m_context.getResource(AssetRecordResource.class);
    }

    private OnmsCriteria getQueryFilters() {
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria, 10, false);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, false);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsNode.class);
        criteria.createAlias("snmpInterfaces", "snmpInterface", 1);
        criteria.createAlias("ipInterfaces", "ipInterface", 1);
        return this.getDistinctIdCriteria(OnmsNode.class, criteria);
    }

    private void sendEvent(String uei, int nodeId) throws EventProxyException {
        Event e = new Event();
        e.setUei(uei);
        e.setNodeid((long)nodeId);
        e.setSource(this.getClass().getName());
        e.setTime(EventConstants.formatToString((Date)new Date()));
        this.m_eventProxy.send(e);
    }
}

