/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.hibernate.criterion.Order;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="events")
public class EventRestService
extends OnmsRestService {
    @Autowired
    private EventDao m_eventDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    HttpHeaders m_headers;
    @Context
    SecurityContext m_securityContext;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{eventId}")
    @Transactional
    public OnmsEvent getEvent(@PathParam(value="eventId") String eventId) {
        OnmsEvent result = (OnmsEvent)this.m_eventDao.get((Serializable)new Integer(eventId));
        return result;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_eventDao.countAll());
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    public OnmsEventCollection getEvents() throws ParseException {
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsEvent.class);
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria, 10, true);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsEvent.class);
        criteria.addOrder(Order.desc((String)"eventTime"));
        OnmsEventCollection eventCol = new OnmsEventCollection((Collection)this.m_eventDao.findMatching(criteria));
        OnmsCriteria crit = new OnmsCriteria(OnmsEvent.class);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, crit, OnmsEvent.class);
        eventCol.setTotalCount(this.m_eventDao.countMatching(crit));
        return eventCol;
    }

    @PUT
    @Path(value="{eventId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public void updateEvent(@PathParam(value="eventId") String eventId, @FormParam(value="ack") Boolean ack) {
        OnmsEvent event = (OnmsEvent)this.m_eventDao.get((Serializable)new Integer(eventId));
        if (ack == null) {
            throw new IllegalArgumentException("Must supply the 'ack' parameter, set to either 'true' or 'false'");
        }
        this.processEventAck(event, ack);
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public void updateEvents(MultivaluedMapImpl formProperties) {
        Boolean ack = false;
        if (formProperties.containsKey("ack")) {
            ack = "true".equals(formProperties.getFirst("ack"));
            formProperties.remove("ack");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsEvent.class);
        this.setLimitOffset(formProperties, criteria, 10, true);
        this.addFiltersToCriteria(formProperties, criteria, OnmsEvent.class);
        for (OnmsEvent event : this.m_eventDao.findMatching(criteria)) {
            this.processEventAck(event, ack);
        }
    }

    private void processEventAck(OnmsEvent event, Boolean ack) {
        if (ack.booleanValue()) {
            event.setEventAckTime(new Date());
            event.setEventAckUser(this.m_securityContext.getUserPrincipal().getName());
        } else {
            event.setEventAckTime(null);
            event.setEventAckUser(null);
        }
        this.m_eventDao.save((Object)event);
    }
}

