/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="assetRecord")
@Transactional
public class AssetRecordResource
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsAssetRecord getAssetRecord(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "getCategories: Can't find node " + nodeCriteria);
        }
        return this.getAssetRecord(node);
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateAssetRecord(@PathParam(value="nodeCriteria") String nodeCriteria, MultivaluedMapImpl params) {
        OnmsAssetRecord assetRecord;
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            this.throwException(Response.Status.BAD_REQUEST, "updateAssetRecord: Can't find node " + nodeCriteria);
        }
        if ((assetRecord = this.getAssetRecord(node)) == null) {
            this.throwException(Response.Status.BAD_REQUEST, "updateAssetRecord: Node " + node + " could not update ");
        }
        this.log().debug("updateAssetRecord: updating category " + assetRecord);
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)assetRecord);
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
        }
        this.log().debug("updateAssetRecord: assetRecord " + assetRecord + " updated");
        this.m_nodeDao.saveOrUpdate((Object)node);
        try {
            this.sendEvent("uei.opennms.org/nodes/assetInfoChanged", node.getId());
        }
        catch (EventProxyException e) {
            this.throwException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return Response.ok().build();
    }

    private OnmsAssetRecord getAssetRecord(OnmsNode node) {
        return node.getAssetRecord();
    }

    private void sendEvent(String uei, int nodeId) throws EventProxyException {
        Event e = new Event();
        e.setUei(uei);
        e.setNodeid((long)nodeId);
        e.setSource(this.getClass().getName());
        e.setTime(EventConstants.formatToString((Date)new Date()));
        this.m_eventProxy.send(e);
    }
}

