/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.hibernate.FetchMode;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAlarmCollection;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="alarms")
public class AlarmRestService
extends OnmsRestService {
    @Autowired
    private AlarmDao m_alarmDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    SecurityContext m_securityContext;

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{alarmId}")
    @Transactional
    public OnmsAlarm getNotification(@PathParam(value="alarmId") String alarmId) {
        OnmsAlarm result = (OnmsAlarm)this.m_alarmDao.get((Serializable)new Integer(alarmId));
        return result;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_alarmDao.countAll());
    }

    @GET
    @Produces(value={"text/xml"})
    @Transactional
    public OnmsAlarmCollection getNotifications() {
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, false);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsAlarm.class);
        criteria.setFetchMode("firstEvent", FetchMode.JOIN);
        criteria.setFetchMode("lastEvent", FetchMode.JOIN);
        return new OnmsAlarmCollection((Collection)this.m_alarmDao.findMatching(this.getDistinctIdCriteria(OnmsAlarm.class, criteria)));
    }

    @PUT
    @Path(value="{alarmId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public void updateAlarm(@PathParam(value="alarmId") String alarmId, @FormParam(value="ack") Boolean ack) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)new Integer(alarmId));
        if (ack == null) {
            throw new IllegalArgumentException("Must supply the 'ack' parameter, set to either 'true' or 'false'");
        }
        this.processAlarmAck(alarm, ack);
    }

    @PUT
    @Transactional
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void updateAlarms(MultivaluedMapImpl formProperties) {
        Boolean ack = false;
        if (formProperties.containsKey("ack")) {
            ack = "true".equals(formProperties.getFirst("ack"));
            formProperties.remove("ack");
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        this.setLimitOffset(formProperties, criteria, 10, true);
        this.addFiltersToCriteria(formProperties, criteria, OnmsAlarm.class);
        for (OnmsAlarm alarm : this.m_alarmDao.findMatching(criteria)) {
            this.processAlarmAck(alarm, ack);
        }
    }

    private void processAlarmAck(OnmsAlarm alarm, Boolean ack) {
        if (ack.booleanValue()) {
            alarm.setAlarmAckTime(new Date());
            alarm.setAlarmAckUser(this.m_securityContext.getUserPrincipal().getName());
        } else {
            alarm.setAlarmAckTime(null);
            alarm.setAlarmAckUser(null);
        }
        this.m_alarmDao.save((Object)alarm);
    }
}

