/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.AcknowledgmentDao;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAcknowledgmentCollection;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.acknowledgments.AckService;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="acks")
public class AcknowledgmentRestService
extends OnmsRestService {
    @Autowired
    private AcknowledgmentDao m_ackDao;
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private AckService m_ackSvc;
    @Context
    UriInfo m_uriInfo;
    @Context
    SecurityContext m_securityContext;

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{id}")
    @Transactional
    public OnmsAcknowledgment getAcknowledgment(@PathParam(value="id") String alarmId) {
        OnmsAcknowledgment result = (OnmsAcknowledgment)this.m_ackDao.get((Serializable)new Integer(alarmId));
        return result;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_ackDao.countAll());
    }

    @GET
    @Produces(value={"text/xml"})
    @Transactional
    public OnmsAcknowledgmentCollection getAcks() {
        MultivaluedMap params = this.m_uriInfo.getQueryParameters();
        OnmsCriteria criteria = new OnmsCriteria(OnmsAcknowledgment.class);
        this.setLimitOffset((MultivaluedMap<String, String>)params, criteria);
        this.addOrdering((MultivaluedMap<String, String>)params, criteria, false);
        this.addFiltersToCriteria((MultivaluedMap<String, String>)params, criteria, OnmsAcknowledgment.class);
        return new OnmsAcknowledgmentCollection((Collection)this.m_ackDao.findMatching(this.getDistinctIdCriteria(OnmsAcknowledgment.class, criteria)));
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public OnmsAcknowledgment acknowledgeAlarm(@FormParam(value="alarmId") String alarmId, @FormParam(value="action") String action) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm);
        if (action == null) {
            action = "ack";
        }
        if ("ack".equals(action)) {
            ack.setAckAction(AckAction.ACKNOWLEDGE);
        } else if ("unack".equals(action)) {
            ack.setAckAction(AckAction.UNACKNOWLEDGE);
        } else if ("clear".equals(action)) {
            ack.setAckAction(AckAction.CLEAR);
        } else if ("esc".equals(action)) {
            ack.setAckAction(AckAction.ESCALATE);
        } else {
            throw new IllegalArgumentException("Must supply the 'action' parameter, set to either 'ack, 'unack', 'clear', or 'esc'");
        }
        this.m_ackSvc.processAck(ack);
        return ack;
    }
}

