/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.report.database;

import java.util.List;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.api.reporting.parameter.ReportStringParm;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.validation.ValidationContext;

public class ReportParametersValidator {
    public void validateReportParameters(ReportParameters reportCriteria, ValidationContext context) {
        MessageContext messages = context.getMessageContext();
        List dateParms = reportCriteria.getDateParms();
        for (ReportDateParm dateParm : dateParms) {
            if (dateParm.getValue() != null) continue;
            messages.addMessage(new MessageBuilder().error().source((Object)"date parms").defaultText("cannot have null date field" + dateParm.getDisplayName()).build());
        }
        List stringParms = reportCriteria.getStringParms();
        for (ReportStringParm stringParm : stringParms) {
            if (stringParm.getValue() != "") continue;
            messages.addMessage(new MessageBuilder().error().source((Object)"string parms").defaultText("cannot have empty string field" + stringParm.getDisplayName()).build());
        }
        List intParms = reportCriteria.getIntParms();
        for (ReportIntParm intParm : intParms) {
            if (intParm.getValue() != 0) continue;
            messages.addMessage(new MessageBuilder().error().source((Object)"int parms").defaultText("cannot have zero integer field" + intParm.getDisplayName()).build());
        }
    }
}

