/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.pathOutage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.web.WebSecurityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathOutageFactory {
    private static final String GET_CRITICAL_PATHS = "SELECT DISTINCT criticalpathip, criticalpathservicename FROM pathoutage ORDER BY criticalpathip, criticalpathservicename";
    private static final String GET_CRITICAL_PATH_BY_NODEID = "SELECT criticalpathip, criticalpathservicename FROM pathoutage WHERE nodeid=?";
    private static final String GET_NODES_IN_PATH = "SELECT DISTINCT pathoutage.nodeid FROM pathoutage, ipinterface WHERE pathoutage.criticalpathip=? AND pathoutage.criticalpathservicename=? AND pathoutage.nodeid=ipinterface.nodeid AND ipinterface.ismanaged!='D' ORDER BY nodeid";
    private static final String COUNT_MANAGED_SVCS = "SELECT count(*) FROM ifservices WHERE status ='A' and nodeid=?";
    private static final String COUNT_OUTAGES = "SELECT count(*) FROM outages WHERE svcregainedeventid IS NULL and nodeid=?";
    private static final String COUNT_NODES_IN_PATH = "SELECT count(DISTINCT pathoutage.nodeid) FROM pathoutage, ipinterface WHERE pathoutage.criticalpathip=? AND pathoutage.criticalpathservicename=? AND pathoutage.nodeid=ipinterface.nodeid AND ipinterface.ismanaged!='D'";
    private static final String GET_NODELABEL_BY_IP = "SELECT nodelabel FROM node WHERE nodeid IN (SELECT nodeid FROM ipinterface WHERE ipaddr=? AND ismanaged!='D')";
    private static final String GET_NODEID_BY_IP = "SELECT nodeid FROM ipinterface WHERE ipaddr=? AND ismanaged!='D' ORDER BY nodeid DESC LIMIT 1";
    private static final String GET_NODELABEL_BY_NODEID = "SELECT nodelabel FROM node WHERE nodeid=?";
    private static final String GET_CRITICAL_PATH_STATUS = "SELECT count(*) FROM outages WHERE ipaddr=? AND ifregainedservice IS NULL AND serviceid=(SELECT serviceid FROM service WHERE servicename=?)";
    private static final String IS_CRITICAL_PATH_MANAGED = "SELECT count(*) FROM ifservices WHERE ipaddr=? AND status='A' AND serviceid=(SELECT serviceid FROM service WHERE servicename=?)";
    public static final String NO_CRITICAL_PATH = "Not Configured";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllCriticalPaths() throws SQLException {
        Connection conn = Vault.getDbConnection();
        ArrayList<String[]> paths = new ArrayList<String[]>();
        try {
            PreparedStatement stmt = conn.prepareStatement(GET_CRITICAL_PATHS);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String[] path = new String[]{rs.getString(1), rs.getString(2)};
                paths.add(path);
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCriticalPath(int nodeID) throws SQLException {
        DBUtils d = new DBUtils(PathOutageFactory.class);
        String result = NO_CRITICAL_PATH;
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(GET_CRITICAL_PATH_BY_NODEID);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                result = rs.getString(1) + " " + rs.getString(2);
            }
        }
        finally {
            d.cleanUp();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getNodesInPath(String criticalPathIp, String criticalPathServiceName) throws SQLException {
        Connection conn = Vault.getDbConnection();
        ArrayList<String> pathNodes = new ArrayList<String>();
        try {
            PreparedStatement stmt = conn.prepareStatement(GET_NODES_IN_PATH);
            stmt.setString(1, criticalPathIp);
            stmt.setString(2, criticalPathServiceName);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                pathNodes.add(rs.getString(1));
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return pathNodes;
    }

    public static String[] getLabelAndStatus(String nodeIDStr, Connection conn) throws SQLException {
        int countManagedSvcs = 0;
        int countOutages = 0;
        String[] result = new String[3];
        result[1] = "Cleared";
        result[2] = "Unmanaged";
        int nodeID = WebSecurityUtils.safeParseInt((String)nodeIDStr);
        PreparedStatement stmt = conn.prepareStatement(GET_NODELABEL_BY_NODEID);
        stmt.setInt(1, nodeID);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            result[0] = rs.getString(1);
        }
        rs.close();
        stmt.close();
        stmt = conn.prepareStatement(COUNT_MANAGED_SVCS);
        stmt.setInt(1, nodeID);
        rs = stmt.executeQuery();
        while (rs.next()) {
            countManagedSvcs = rs.getInt(1);
        }
        rs.close();
        stmt.close();
        if (countManagedSvcs > 0) {
            stmt = conn.prepareStatement(COUNT_OUTAGES);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                countOutages = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            if (countManagedSvcs == countOutages) {
                result[1] = "Critical";
                result[2] = "All Services Down";
            } else if (countOutages == 0) {
                result[1] = "Normal";
                result[2] = "All Services Up";
            } else {
                result[1] = "Minor";
                result[2] = "Some Services Down";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getCriticalPathData(String criticalPathIp, String criticalPathServiceName) throws SQLException {
        Connection conn = Vault.getDbConnection();
        String[] result = new String[4];
        int nodeCount = 0;
        int count = 0;
        try {
            PreparedStatement stmt0 = conn.prepareStatement(GET_NODELABEL_BY_IP);
            stmt0.setString(1, criticalPathIp);
            ResultSet rs0 = stmt0.executeQuery();
            while (rs0.next()) {
                ++count;
                result[0] = rs0.getString(1);
            }
            if (count > 1) {
                result[0] = "(" + count + " nodes have this IP)";
            }
            rs0.close();
            stmt0.close();
            count = 0;
            PreparedStatement stmt1 = conn.prepareStatement(GET_NODEID_BY_IP);
            stmt1.setString(1, criticalPathIp);
            ResultSet rs1 = stmt1.executeQuery();
            while (rs1.next()) {
                result[1] = rs1.getString(1);
            }
            rs1.close();
            stmt1.close();
            PreparedStatement stmt2 = conn.prepareStatement(COUNT_NODES_IN_PATH);
            stmt2.setString(1, criticalPathIp);
            stmt2.setString(2, criticalPathServiceName);
            ResultSet rs2 = stmt2.executeQuery();
            while (rs2.next()) {
                nodeCount = rs2.getInt(1);
            }
            result[2] = Integer.toString(nodeCount);
            rs2.close();
            stmt2.close();
            PreparedStatement stmt = conn.prepareStatement(IS_CRITICAL_PATH_MANAGED);
            stmt.setString(1, criticalPathIp);
            stmt.setString(2, criticalPathServiceName);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            if (count > 0) {
                PreparedStatement stmt3 = conn.prepareStatement(GET_CRITICAL_PATH_STATUS);
                stmt3.setString(1, criticalPathIp);
                stmt3.setString(2, criticalPathServiceName);
                ResultSet rs3 = stmt3.executeQuery();
                while (rs3.next()) {
                    count = rs3.getInt(1);
                }
                result[3] = count > 0 ? "Critical" : "Normal";
                while (rs3.next()) {
                    result[3] = rs3.getString(1);
                }
                rs3.close();
                stmt3.close();
            } else {
                result[3] = "Cleared";
            }
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return result;
    }
}

