/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import java.sql.SQLException;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.SQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFilter
extends EqualsFilter<Integer> {
    public static final String TYPE = "service";

    public ServiceFilter(int serviceId) {
        super(TYPE, SQLType.INT, "OUTAGES.SERVICEID", "serviceType.id", serviceId);
    }

    @Override
    public String getTextDescription() {
        int serviceId = this.getServiceId();
        String serviceName = Integer.toString(serviceId);
        try {
            serviceName = NetworkElementFactory.getServiceNameFromId(serviceId);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not get the service name for id " + serviceId);
        }
        return "service is " + serviceName;
    }

    @Override
    public String toString() {
        return "<ServiceFilter: " + this.getDescription() + ">";
    }

    public int getServiceId() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

