/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.filter.SQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentOutagesFilter
extends OneArgFilter<Date> {
    public static final String TYPE = "recent";

    public RecentOutagesFilter() {
        this(RecentOutagesFilter.yesterday());
    }

    public RecentOutagesFilter(Date since) {
        super(TYPE, SQLType.DATE, "OUTAGES.IFREGAINEDSERVICE", "ifRegainedService", since);
    }

    @Override
    public String getSQLTemplate() {
        return " (" + this.getSQLFieldName() + " > %s OR " + this.getSQLFieldName() + " IS NULL) ";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.or((Criterion)Restrictions.gt((String)this.getPropertyName(), this.getValue()), (Criterion)Restrictions.isNull((String)this.getPropertyName()));
    }

    @Override
    public String getTextDescription() {
        return "outage since " + this.getValueAsString(this.getValue());
    }

    public static Date yesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }
}

