/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OutageType {
    CURRENT("current"),
    RESOLVED("resolved"),
    BOTH("both"),
    SUPPRESSED("suppressed");

    private static final Map<String, OutageType> s_outageTypesString;
    private String m_shortName;

    private OutageType(String shortName) {
        this.m_shortName = shortName;
    }

    public String toString() {
        return "Outage." + this.getName();
    }

    public String getName() {
        return this.name();
    }

    public String getShortName() {
        return this.m_shortName;
    }

    protected String getClause() {
        String clause = null;
        switch (this) {
            case CURRENT: {
                clause = " IFREGAINEDSERVICE IS NULL AND SUPPRESSTIME IS NULL ";
                break;
            }
            case RESOLVED: {
                clause = " IFREGAINEDSERVICE IS NOT NULL AND SUPPRESSTIME IS NULL ";
                break;
            }
            case SUPPRESSED: {
                clause = " ((SUPPRESSEDTIME IS NOT NULL) AND (SUPPRESSTIME > NOW())) AND IFREGAINEDSERVICE IS NULL";
                break;
            }
            case BOTH: {
                clause = " TRUE AND SUPPRESSTIME IS NULL ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown OutageType: " + this.getName());
            }
        }
        return clause;
    }

    public static OutageType getOutageType(String outageTypeString) {
        Assert.notNull((Object)outageTypeString, (String)"Cannot take null parameters.");
        return s_outageTypesString.get(outageTypeString.toLowerCase());
    }

    static {
        s_outageTypesString = new HashMap<String, OutageType>();
        for (OutageType outageType : OutageType.values()) {
            s_outageTypesString.put(outageType.getShortName(), outageType);
        }
    }
}

