/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.util.Date;
import org.opennms.core.utils.FuzzyDateFormatter;

public class OutageSummary {
    protected final int nodeId;
    protected final String nodeLabel;
    protected final Date timeDown;
    protected final Date timeUp;
    protected final Date timeNow;

    public OutageSummary(int nodeId, String nodeLabel, Date timeDown, Date timeUp, Date timeNow) {
        if (nodeLabel == null || timeDown == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.nodeId = nodeId;
        this.nodeLabel = nodeLabel;
        this.timeDown = timeDown;
        this.timeUp = timeUp;
        this.timeNow = timeNow;
    }

    public OutageSummary(int nodeId, String nodeLabel, Date timeDown, Date timeUp) {
        this(nodeId, nodeLabel, timeDown, timeUp, new Date());
    }

    public OutageSummary(int nodeId, String nodeLabel, Date timeDown) {
        this(nodeId, nodeLabel, timeDown, null, new Date());
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getHostname() {
        return this.nodeLabel;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public Date getTimeDown() {
        return this.timeDown;
    }

    public Date getTimeUp() {
        return this.timeUp;
    }

    public String getFuzzyTimeDown() {
        return FuzzyDateFormatter.calculateDifference((Date)this.getTimeDown(), (Date)new Date());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<OutageSummary: ");
        buffer.append(this.nodeId);
        buffer.append(":");
        buffer.append(this.nodeLabel);
        buffer.append(", down at ");
        buffer.append(this.timeDown);
        if (this.timeUp != null) {
            buffer.append(", back up at ");
            buffer.append(this.timeUp);
        }
        return buffer.toString();
    }
}

