/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.opennms.core.resource.Vault;
import org.opennms.web.element.Node;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.OutageSummary;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutageModel {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getCurrentOutages() throws SQLException {
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select o.outageid, o.nodeId, n.nodeLabel, o.ipaddr, ip.iphostname, s.servicename, o.serviceId, o.iflostservice, o.svclosteventid, no.notifyId, no.answeredBy from outages o left outer join notifications no on (o.svclosteventid = no.eventid) join ifservices if on (if.id = o.ifserviceid) join ipinterface ip on (ip.id = if.ipinterfaceid) join node n on (n.nodeid = ip.nodeid) join service s on (s.serviceid = if.serviceid) where ifregainedservice is null and n.nodeType != 'D' and ip.isManaged != 'D' and if.status != 'D' and o.serviceid=s.serviceid and (o.suppresstime is null or o.suppresstime < now()) order by n.nodelabel, ip.ipaddr, s.serviceName");
            outages = OutageModel.rs2Outages(rs, false, true);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getSuppressedOutages() throws SQLException {
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select o.outageid, o.nodeId, n.nodeLabel, o.ipaddr, ip.iphostname, s.servicename, o.serviceId, o.iflostservice, o.svclosteventid, no.notifyId, no.answeredBy from outages o left outer join notifications no on (o.svclosteventid = no.eventid) join ifservices if on (if.id = o.ifserviceid) join ipinterface ip on (ip.id = if.ipinterfaceid) join node n on (n.nodeid = ip.nodeid) join service s on (s.serviceid = if.serviceid) where ifregainedservice is null and n.nodeType != 'D' and ip.isManaged != 'D' and if.status != 'D' and o.serviceid=s.serviceid and o.suppresstime > now() order by n.nodelabel, ip.ipaddr, s.serviceName");
            outages = OutageModel.rs2Outages(rs, false, true);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentOutageCount() throws SQLException {
        int count = 0;
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select count(o.outageid) from outages o left outer join notifications no on (o.svclosteventid = no.eventid) join ifservices if on (if.id = o.ifserviceid) join ipinterface ip on (ip.id = if.ipinterfaceid) join node n on (n.nodeid = ip.nodeid) join service s on (s.serviceid = if.serviceid) where ifregainedservice is null and n.nodeType != 'D' and ip.isManaged != 'D' and if.status != 'D' and o.serviceid=s.serviceid and (o.suppresstime is null or o.suppresstime < now()) ");
            if (rs.next()) {
                count = rs.getInt("count");
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuppressedOutageCount() throws SQLException {
        int count = 0;
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select count(o.outageid) from outages o left outer join notifications no on (o.svclosteventid = no.eventid) join ifservices if on (if.id = o.ifserviceid) join ipinterface ip on (ip.id = if.ipinterfaceid) join node n on (n.nodeid = ip.nodeid) join service s on (s.serviceid = if.serviceid) where ifregainedservice is null and n.nodeType != 'D' and ip.isManaged != 'D' and if.status != 'D' and o.serviceid=s.serviceid and o.suppresstime > now() ");
            if (rs.next()) {
                count = rs.getInt("count");
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getCurrentOutagesForNode(int nodeId) throws SQLException {
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.outageid, outages.iflostservice, outages.ifregainedservice, outages.nodeID, node.nodeLabel, outages.ipaddr, ipinterface.iphostname, service.servicename, outages.serviceId from outages, node, ipinterface, service where outages.nodeid=? and node.nodeid=outages.nodeid and outages.serviceid=service.serviceid and ipinterface.ipaddr=outages.ipaddr and ifregainedservice is null  and suppresstime is null or suppresstime < now()order by iflostservice desc");
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            outages = OutageModel.rs2Outages(rs, false);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> getCurrentOutagesIdsForNode(int nodeId) throws SQLException {
        ArrayList<Integer> outageIds = new ArrayList<Integer>();
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outageid from outages where nodeid=?  and ifregainedservice is null and suppresstime is null or suppresstime < now();");
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                outageIds.add(rs.getInt(1));
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outageIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node[] filterNodesWithCurrentOutages(Node[] nodes) throws SQLException {
        HashMap<Integer, Node> nodeMap = new HashMap<Integer, Node>(nodes.length);
        for (Node n : nodes) {
            nodeMap.put(n.getNodeId(), n);
        }
        String nodeList = StringUtils.collectionToDelimitedString(nodeMap.keySet(), (String)", ");
        ArrayList newNodes = new ArrayList();
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT nodeid from outages where nodeid in ( " + nodeList + " ) and ifregainedservice is null and suppresstime is null or suppresstime < now();");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                newNodes.add(nodeMap.get(rs.getInt(1)));
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return newNodes.toArray(new Node[newNodes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getNonCurrentOutagesForNode(int nodeId) throws SQLException {
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.outageid, outages.iflostservice, outages.ifregainedservice, outages.nodeID, node.nodeLabel, outages.ipaddr, ipinterface.iphostname, service.servicename, outages.serviceId from outages, node, ipinterface, service where outages.nodeid=? and node.nodeid=outages.nodeid and outages.serviceid=service.serviceid and ipinterface.ipaddr=outages.ipaddr and ifregainedservice is not null  and suppresstime is null or suppresstime < now() order by iflostservice desc");
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            outages = OutageModel.rs2Outages(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getOutagesForNode(int nodeId) throws SQLException {
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.outageid, outages.iflostservice, outages.ifregainedservice, outages.nodeID, node.nodeLabel, outages.ipaddr, ipinterface.iphostname, service.servicename, outages.serviceId from outages, node, ipinterface, service where outages.nodeid=? and node.nodeid=outages.nodeid and outages.serviceid=service.serviceid and ipinterface.ipaddr=outages.ipaddr order by iflostservice desc");
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            outages = OutageModel.rs2Outages(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getOutagesForNode(int nodeId, Date time) throws SQLException {
        if (time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        long timeLong = time.getTime();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.outageid, outages.iflostservice, outages.ifregainedservice, outages.nodeID, node.nodeLabel, outages.ipaddr, ipinterface.iphostname, service.servicename, outages.serviceId from outages, node, ipinterface, service where outages.nodeid=? and node.nodeid=outages.nodeid and outages.serviceid=service.serviceid and ipinterface.ipaddr=outages.ipaddr and (ifregainedservice >= ? or ifregainedservice is null) order by iflostservice desc");
            stmt.setInt(1, nodeId);
            stmt.setTimestamp(2, new Timestamp(timeLong));
            ResultSet rs = stmt.executeQuery();
            outages = OutageModel.rs2Outages(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getOutagesForInterface(int nodeId, String ipInterface) throws SQLException {
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.outageid, outages.iflostservice, outages.ifregainedservice, outages.nodeID, node.nodeLabel, outages.ipaddr, ipinterface.iphostname, service.servicename, outages.serviceId from outages, node, ipinterface, service where outages.nodeid=? and outages.ipaddr=? and node.nodeid=outages.nodeid and outages.serviceid=service.serviceid and ipinterface.ipaddr=outages.ipaddr order by iflostservice desc");
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipInterface);
            ResultSet rs = stmt.executeQuery();
            outages = OutageModel.rs2Outages(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getOutagesForInterface(int nodeId, String ipAddr, Date time) throws SQLException {
        if (ipAddr == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        long timeLong = time.getTime();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.outageid, outages.iflostservice, outages.ifregainedservice, outages.nodeID, node.nodeLabel, outages.ipaddr, ipinterface.iphostname, service.servicename, outages.serviceId from outages, node, ipinterface, service where outages.nodeid=? and outages.ipaddr=? and node.nodeid=outages.nodeid and outages.serviceid=service.serviceid and ipinterface.ipaddr=outages.ipaddr and (ifregainedservice >= ? or ifregainedservice is null) order by iflostservice desc");
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setTimestamp(3, new Timestamp(timeLong));
            ResultSet rs = stmt.executeQuery();
            outages = OutageModel.rs2Outages(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getOutagesForService(int nodeId, String ipInterface, int serviceId) throws SQLException {
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.outageid, outages.iflostservice, outages.ifregainedservice, outages.nodeID, node.nodeLabel, outages.ipaddr, ipinterface.iphostname, service.servicename, outages.serviceId from outages, node, ipinterface, service where outages.nodeid=? and outages.ipaddr=? and outages.serviceid=? and node.nodeid=outages.nodeid and outages.serviceid=service.serviceid and ipinterface.ipaddr=outages.ipaddr order by iflostservice desc");
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipInterface);
            stmt.setInt(3, serviceId);
            ResultSet rs = stmt.executeQuery();
            outages = OutageModel.rs2Outages(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outage[] getOutagesForService(int nodeId, String ipAddr, int serviceId, Date time) throws SQLException {
        if (ipAddr == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Outage[] outages = new Outage[]{};
        Connection conn = Vault.getDbConnection();
        long timeLong = time.getTime();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.outageid, outages.iflostservice, outages.ifregainedservice, outages.nodeID, node.nodeLabel, outages.ipaddr, ipinterface.iphostname, service.servicename, outages.serviceId from outages, node, ipinterface, service where outages.nodeid=? and outages.ipaddr=? and outages.serviceid=? and node.nodeid=outages.nodeid and outages.serviceid=service.serviceid and ipinterface.ipaddr=outages.ipaddr and (ifregainedservice >= ? or ifregainedservice is null) order by iflostservice desc");
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setInt(3, serviceId);
            stmt.setTimestamp(4, new Timestamp(timeLong));
            ResultSet rs = stmt.executeQuery();
            outages = OutageModel.rs2Outages(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutageSummary[] getCurrentOutageSummaries() throws SQLException {
        OutageSummary[] summaries = new OutageSummary[]{};
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select distinct outages.nodeid, max(outages.iflostservice) as timeDown, node.nodelabel, now() as timeNow from outages, node, ipinterface, ifservices where ifregainedservice is null and node.nodeid=outages.nodeid and ipinterface.nodeid = outages.nodeid and ifservices.nodeid=outages.nodeid and ipinterface.ipaddr = outages.ipaddr and ifservices.ipaddr = outages.ipaddr and ifservices.serviceid = outages.serviceid and node.nodeType != 'D' and ipinterface.ismanaged != 'D' and ifservices.status != 'D' group by outages.nodeid, node.nodelabel order by timeDown desc;");
            ArrayList<OutageSummary> list = new ArrayList<OutageSummary>();
            while (rs.next()) {
                int nodeId = rs.getInt("nodeID");
                Timestamp timeDownTS = rs.getTimestamp("timeDown");
                long timeDown = timeDownTS.getTime();
                Date downDate = new Date(timeDown);
                String nodeLabel = rs.getString("nodelabel");
                Date now = new Date(rs.getTimestamp("timeNow").getTime());
                list.add(new OutageSummary(nodeId, nodeLabel, downDate, null, now));
            }
            rs.close();
            stmt.close();
            summaries = list.toArray(new OutageSummary[list.size()]);
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return summaries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutageSummary[] getAllOutageSummaries(Date date) throws SQLException {
        OutageSummary[] summaries = new OutageSummary[]{};
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT outages.nodeid, outages.iflostservice as timeDown, outages.ifregainedservice as timeUp, node.nodelabel FROM outages, node, ipinterface, ifservices WHERE node.nodeid=outages.nodeid AND ipinterface.nodeid=outages.nodeid AND ifservices.nodeid=outages.nodeid AND ipinterface.ipaddr=outages.ipaddr AND ifservices.ipaddr=outages.ipaddr AND ifservices.serviceid=outages.serviceid AND node.nodeType != 'D' AND ipinterface.ismanaged != 'D' AND ifservices.status != 'D' AND outages.iflostservice >= ? ORDER BY timeDown DESC;");
            stmt.setTimestamp(1, new Timestamp(date.getTime()));
            ResultSet rs = stmt.executeQuery();
            ArrayList<OutageSummary> list = new ArrayList<OutageSummary>();
            while (rs.next()) {
                int nodeId = rs.getInt("nodeID");
                Timestamp timeDown = rs.getTimestamp("timeDown");
                Date downDate = new Date(timeDown.getTime());
                Timestamp timeUp = rs.getTimestamp("timeUp");
                Date upDate = null;
                if (timeUp != null) {
                    upDate = new Date(timeUp.getTime());
                }
                String nodeLabel = rs.getString("nodelabel");
                list.add(new OutageSummary(nodeId, nodeLabel, downDate, upDate));
            }
            rs.close();
            stmt.close();
            summaries = list.toArray(new OutageSummary[list.size()]);
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return summaries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutageSummary[] getCurrentSDSOutageSummaries() throws SQLException {
        OutageSummary[] summaries = new OutageSummary[]{};
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select distinct outages.nodeid, max(outages.iflostservice) as timeDown, node.nodelabel from outages, node, ipinterface, ifservices, assets where ifregainedservice is null and node.nodeid=outages.nodeid and ipinterface.nodeid = outages.nodeid and ifservices.nodeid=outages.nodeid and ipinterface.ipaddr = outages.ipaddr and ifservices.ipaddr = outages.ipaddr and ifservices.serviceid = outages.serviceid and node.nodeType != 'D' and ipinterface.ismanaged != 'D' and ifservices.status != 'D' and assets.nodeid=node.nodeid and assets.displaycategory != 'SDS-A-Side' and assets.displaycategory != 'SDS-B-Side' group by outages.nodeid, node.nodelabel order by timeDown desc;");
            ArrayList<OutageSummary> list = new ArrayList<OutageSummary>();
            while (rs.next()) {
                int nodeId = rs.getInt("nodeID");
                Timestamp timeDownTS = rs.getTimestamp("timeDown");
                long timeDown = timeDownTS.getTime();
                Date downDate = new Date(timeDown);
                String nodeLabel = rs.getString("nodelabel");
                list.add(new OutageSummary(nodeId, nodeLabel, downDate));
            }
            rs.close();
            stmt.close();
            summaries = list.toArray(new OutageSummary[list.size()]);
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return summaries;
    }

    protected static Outage[] rs2Outages(ResultSet rs) throws SQLException {
        return OutageModel.rs2Outages(rs, true);
    }

    protected static Outage[] rs2Outages(ResultSet rs, boolean includesRegainedTime) throws SQLException {
        return OutageModel.rs2Outages(rs, includesRegainedTime, false);
    }

    protected static Outage[] rs2Outages(ResultSet rs, boolean includesRegainedTime, boolean includesNotifications) throws SQLException {
        Outage[] outages = null;
        ArrayList<Outage> list = new ArrayList<Outage>();
        while (rs.next()) {
            Outage outage = new Outage();
            outage.nodeId = rs.getInt("nodeid");
            outage.ipAddress = rs.getString("ipaddr");
            outage.serviceId = rs.getInt("serviceid");
            outage.nodeLabel = rs.getString("nodeLabel");
            outage.hostname = rs.getString("iphostname");
            outage.serviceName = rs.getString("servicename");
            outage.outageId = rs.getInt("outageid");
            Timestamp lostService = rs.getTimestamp("iflostservice");
            if (!rs.wasNull()) {
                outage.lostServiceTime = new Date(lostService.getTime());
            }
            if (includesRegainedTime) {
                Timestamp regainedService = rs.getTimestamp("ifregainedservice");
                if (!rs.wasNull()) {
                    outage.regainedServiceTime = new Date(regainedService.getTime());
                }
            }
            if (includesNotifications) {
                int serviceLostEventId = rs.getInt("svclosteventid");
                if (!rs.wasNull()) {
                    outage.lostServiceEventId = new Integer(serviceLostEventId);
                }
                int notifyId = rs.getInt("notifyid");
                if (!rs.wasNull()) {
                    outage.lostServiceNotificationId = new Integer(notifyId);
                }
                outage.lostServiceNotificationAcknowledgedBy = rs.getString("answeredby");
            }
            list.add(outage);
        }
        outages = list.toArray(new Outage[list.size()]);
        return outages;
    }
}

