/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.web.filter.Filter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.OutageSummary;
import org.opennms.web.outage.OutageType;
import org.opennms.web.outage.SortStyle;
import org.opennms.web.outage.WebOutageRepository;
import org.opennms.web.outage.filter.OutageCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoWebOutageRepository
implements WebOutageRepository {
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private NodeDao m_nodeDao;

    private OnmsCriteria getOnmsCriteria(OutageCriteria outageCriteria) {
        final OnmsCriteria criteria = new OnmsCriteria(OnmsOutage.class);
        criteria.createAlias("monitoredService", "monitoredService");
        criteria.createAlias("monitoredService.ipInterface", "ipInterface");
        criteria.createAlias("monitoredService.ipInterface.node", "node");
        criteria.createAlias("monitoredService.serviceType", "serviceType");
        outageCriteria.visit(new OutageCriteria.OutageCriteriaVisitor<RuntimeException>(){

            @Override
            public void visitOutageType(OutageType ackType) throws RuntimeException {
                if (ackType == OutageType.CURRENT) {
                    criteria.add(Restrictions.isNull((String)"ifRegainedService"));
                } else if (ackType == OutageType.RESOLVED) {
                    criteria.add(Restrictions.isNotNull((String)"ifRegainedService"));
                }
            }

            @Override
            public void visitFilter(Filter filter) throws RuntimeException {
                criteria.add(filter.getCriterion());
            }

            @Override
            public void visitGroupBy() throws RuntimeException {
            }

            @Override
            public void visitLimit(int limit, int offset) throws RuntimeException {
                criteria.setMaxResults(Integer.valueOf(limit));
                criteria.setFirstResult(Integer.valueOf(offset));
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) throws RuntimeException {
                switch (sortStyle) {
                    case NODE: {
                        criteria.addOrder(Order.desc((String)"node.label"));
                        break;
                    }
                    case INTERFACE: {
                        criteria.addOrder(Order.desc((String)"ipInterface.ipAddress"));
                        break;
                    }
                    case SERVICE: {
                        criteria.addOrder(Order.desc((String)"serviceType.name"));
                        break;
                    }
                    case IFLOSTSERVICE: {
                        criteria.addOrder(Order.desc((String)"ifLostService"));
                        break;
                    }
                    case IFREGAINEDSERVICE: {
                        criteria.addOrder(Order.desc((String)"ifRegainedService"));
                        break;
                    }
                    case ID: {
                        criteria.addOrder(Order.desc((String)"id"));
                        break;
                    }
                    case REVERSE_NODE: {
                        criteria.addOrder(Order.asc((String)"node.label"));
                        break;
                    }
                    case REVERSE_INTERFACE: {
                        criteria.addOrder(Order.asc((String)"ipInterface.ipAddress"));
                        break;
                    }
                    case REVERSE_SERVICE: {
                        criteria.addOrder(Order.asc((String)"serviceType.name"));
                        break;
                    }
                    case REVERSE_IFLOSTSERVICE: {
                        criteria.addOrder(Order.asc((String)"ifLostService"));
                        break;
                    }
                    case REVERSE_IFREGAINEDSERVICE: {
                        criteria.addOrder(Order.asc((String)"ifRegainedService"));
                        break;
                    }
                    case REVERSE_ID: {
                        criteria.addOrder(Order.asc((String)"id"));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown SortStyle: " + (Object)((Object)sortStyle));
                    }
                }
            }
        });
        return criteria;
    }

    private Outage mapOnmsOutageToOutage(OnmsOutage onmsOutage) {
        if (onmsOutage != null) {
            Outage outage = new Outage();
            outage.outageId = onmsOutage.getId();
            outage.ipAddress = onmsOutage.getIpAddress();
            outage.hostname = onmsOutage.getIpAddress();
            outage.lostServiceEventId = onmsOutage.getServiceLostEvent() != null ? onmsOutage.getServiceLostEvent().getId() : 0;
            outage.lostServiceTime = onmsOutage.getIfLostService();
            outage.nodeId = onmsOutage.getNodeId();
            outage.nodeLabel = ((OnmsNode)this.m_nodeDao.get((Serializable)onmsOutage.getNodeId())).getLabel();
            outage.regainedServiceEventId = onmsOutage.getServiceRegainedEvent() != null ? onmsOutage.getServiceRegainedEvent().getId() : 0;
            outage.regainedServiceTime = onmsOutage.getIfRegainedService();
            outage.serviceId = onmsOutage.getServiceId();
            outage.serviceName = onmsOutage.getMonitoredService() != null ? onmsOutage.getMonitoredService().getServiceName() : "";
            outage.suppressedBy = onmsOutage.getSuppressedBy();
            outage.suppressTime = onmsOutage.getSuppressTime();
            return outage;
        }
        return null;
    }

    private OutageSummary mapOnmsOutageToOutageSummary(OnmsOutage onmsOutage) {
        int nodeId = onmsOutage.getNodeId();
        String nodeLabel = ((OnmsNode)this.m_nodeDao.get((Serializable)onmsOutage.getNodeId())).getLabel();
        Date timeDown = onmsOutage.getIfLostService();
        Date timeUp = onmsOutage.getIfRegainedService();
        Date timeNow = new Date();
        return new OutageSummary(nodeId, nodeLabel, timeDown, timeUp, timeNow);
    }

    @Override
    @Transactional
    public int countMatchingOutageSummaries(OutageCriteria criteria) {
        return this.getMatchingOutageSummaries(criteria).length;
    }

    @Override
    @Transactional
    public int countMatchingOutages(OutageCriteria criteria) {
        return this.m_outageDao.countMatching(this.getOnmsCriteria(criteria));
    }

    @Override
    @Transactional
    public OutageSummary[] getMatchingOutageSummaries(OutageCriteria criteria) {
        List onmsOutages = this.m_outageDao.findMatching(this.getOnmsCriteria(criteria));
        return this.getOutageSummary(onmsOutages).toArray(new OutageSummary[0]);
    }

    private List<OutageSummary> getOutageSummary(List<OnmsOutage> onmsOutages) {
        ArrayList<OutageSummary> outages = new ArrayList<OutageSummary>();
        if (onmsOutages.size() > 0) {
            for (OnmsOutage outage : onmsOutages) {
                if (outage.getIfRegainedService() != null) continue;
                outages.add(this.mapOnmsOutageToOutageSummary(outage));
            }
            return this.elimenateDuplicates(outages);
        }
        return outages;
    }

    private List<OutageSummary> elimenateDuplicates(List<OutageSummary> outagesSummaries) {
        ArrayList<OutageSummary> uniqueList = new ArrayList<OutageSummary>();
        for (int i = 0; i < outagesSummaries.size(); ++i) {
            OutageSummary outageSum = outagesSummaries.get(i);
            if (uniqueList.size() > 0) {
                int currentUniqueListSize = uniqueList.size();
                boolean isDirty = false;
                for (int k = 0; k < currentUniqueListSize; ++k) {
                    OutageSummary uniqueSum = (OutageSummary)uniqueList.get(k);
                    if (outageSum.nodeId != uniqueSum.nodeId || !uniqueSum.nodeLabel.equals(outageSum.nodeLabel)) continue;
                    isDirty = true;
                }
                if (isDirty) continue;
                uniqueList.add(outageSum);
                continue;
            }
            uniqueList.add(outageSum);
        }
        return uniqueList;
    }

    @Override
    @Transactional
    public Outage[] getMatchingOutages(OutageCriteria criteria) {
        ArrayList<Outage> outages = new ArrayList<Outage>();
        List onmsOutages = this.m_outageDao.findMatching(this.getOnmsCriteria(criteria));
        if (onmsOutages.size() > 0) {
            Iterator outageIt = onmsOutages.iterator();
            while (outageIt.hasNext()) {
                outages.add(this.mapOnmsOutageToOutage((OnmsOutage)outageIt.next()));
            }
        }
        return outages.toArray(new Outage[0]);
    }

    @Override
    @Transactional
    public Outage getOutage(int OutageId) {
        return this.mapOnmsOutageToOutage((OnmsOutage)this.m_outageDao.get((Serializable)Integer.valueOf(OutageId)));
    }
}

