/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification.filter;

import org.hibernate.Hibernate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.filter.SQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserFilter
extends OneArgFilter<String> {
    public static final String TYPE = "user";

    public UserFilter(String user) {
        super(TYPE, SQLType.STRING, "NOTIFICATIONS.NOTIFYID", "notifyId", user);
    }

    @Override
    public String getSQLTemplate() {
        return " " + this.getSQLFieldName() + " in (SELECT DISTINCT usersnotified.notifyid FROM usersnotified WHERE usersnotified.userid=%s)";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.sqlRestriction((String)" {alias}.notifyId in (SELECT DISTINCT usersnotified.notifyid FROM usersnotified WHERE usersnotified.userid=?)", this.getValue(), (Type)Hibernate.STRING);
    }

    @Override
    public String getTextDescription() {
        return (String)this.getValue() + " was notified";
    }

    @Override
    public String toString() {
        return "<NoticeFactory.UserFilter: " + this.getDescription() + ">";
    }

    public String getUser() {
        return (String)this.getValue();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

