/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification.bobject;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.notification.bobject.Argument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    private String m_commandName;
    private List<String> m_types;
    private String m_commandComments;
    private List<Argument> m_arguments = new ArrayList<Argument>();
    private boolean m_useStream = false;

    public Command() {
        this.m_types = new ArrayList<String>();
    }

    public Command copy() {
        Command copy = new Command();
        copy.setCommandName(this.m_commandName);
        copy.setCommandComments(this.m_commandComments);
        copy.setUseStream(this.m_useStream);
        for (String type : this.m_types) {
            copy.addType(type);
        }
        for (Argument oldArg : this.m_arguments) {
            Argument newArg = new Argument();
            newArg.setSwitch(oldArg.getSwitch());
            newArg.setSubstitution(oldArg.getSubstitution());
            newArg.setValue(oldArg.getValue());
            newArg.setStreamed(oldArg.isStreamed());
            copy.addArgument(newArg);
        }
        return copy;
    }

    public void setCommandName(String aName) {
        this.m_commandName = aName;
    }

    public String getCommandName() {
        return this.m_commandName;
    }

    public void addType(String aType) {
        this.m_types.add(aType);
    }

    public boolean isOfType(String aType) {
        return this.m_types.contains(aType);
    }

    public String getType() {
        return this.m_types.get(0);
    }

    public void setCommandComments(String someComments) {
        this.m_commandComments = someComments;
    }

    public String getCommandComments() {
        return this.m_commandComments;
    }

    public void addArgument(Argument anArgument) {
        this.m_arguments.add(anArgument);
    }

    public void setUseStream(boolean aBool) {
        this.m_useStream = aBool;
    }

    public List getArguments() {
        return this.m_arguments;
    }

    public void setArgumentValue(String aSwitch, String aValue) {
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(aSwitch)) continue;
            arg.setValue(aValue);
            break;
        }
    }

    public boolean hasSwitch(String aSwitch) {
        return this.getArgumentSwitches().contains(aSwitch);
    }

    public List<String> getArgumentSwitches() {
        ArrayList<String> switches = new ArrayList<String>();
        for (Argument argument : this.m_arguments) {
            switches.add(argument.getSwitch());
        }
        return switches;
    }

    public int execute() {
        int returnCode = 0;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.m_commandName);
        for (Argument curArg : this.m_arguments) {
            if (curArg.isStreamed()) continue;
            if (!curArg.getSubstitution().equals("")) {
                args.add(curArg.getSubstitution());
            }
            if (curArg.getValue() == null || curArg.getValue().equals("")) continue;
            args.add(curArg.getValue());
        }
        try {
            String[] arguments = args.toArray(new String[args.size()]);
            Process command = Runtime.getRuntime().exec(arguments);
            if (this.m_useStream) {
                BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(command.getOutputStream(), "UTF-8"));
                StringBuffer buffer = new StringBuffer();
                for (Argument curArg : this.m_arguments) {
                    if (!curArg.isStreamed()) continue;
                    if (!curArg.getSubstitution().equals("")) {
                        buffer.append(curArg.getSubstitution());
                    }
                    if (curArg.getValue().equals("")) continue;
                    buffer.append(curArg.getValue());
                }
                processInput.write(buffer.toString());
                processInput.flush();
                processInput.close();
            }
            returnCode = command.waitFor();
        }
        catch (IOException e) {
            this.log().error("Command failed with IOExceptoin: " + e, (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log().error("Command failed with InterruptedExceptoin: " + e, (Throwable)e);
        }
        this.log().debug("command complete with return code " + returnCode);
        return returnCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_commandName + " ");
        for (Argument arg : this.m_arguments) {
            buffer.append(arg.getSubstitution() + " " + arg.getValue());
        }
        return buffer.toString();
    }

    public static String[] createCommandArray(String s, char delim) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (s.indexOf(delim) != -1) {
            throw new IllegalArgumentException("String parameter cannot already contain delimiter character: " + delim);
        }
        char[] chars = s.toCharArray();
        boolean inquote = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"') {
                inquote = !inquote;
                continue;
            }
            if (inquote && chars[i] == ' ') {
                buffer.append(delim);
                continue;
            }
            buffer.append(chars[i]);
        }
        s = buffer.toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s);
        while (tokenizer.hasMoreTokens()) {
            arrayList.add(tokenizer.nextElement().toString());
        }
        String[] list = arrayList.toArray(new String[arrayList.size()]);
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].replace(delim, ' ');
        }
        return list;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

