/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.util.StringTokenizer;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.notification.filter.AcknowledgedByFilter;
import org.opennms.web.notification.filter.InterfaceFilter;
import org.opennms.web.notification.filter.NodeFilter;
import org.opennms.web.notification.filter.NotificationIdFilter;
import org.opennms.web.notification.filter.ResponderFilter;
import org.opennms.web.notification.filter.ServiceFilter;
import org.opennms.web.notification.filter.UserFilter;

public abstract class NoticeUtil {
    public static Filter getFilter(String filterString) {
        OneArgFilter filter = null;
        StringTokenizer tokens = new StringTokenizer(filterString, "=");
        String type = tokens.nextToken();
        String value = tokens.nextToken();
        if (type.equals("acknowledgeBy")) {
            filter = new AcknowledgedByFilter(value);
        } else if (type.equals("interface")) {
            filter = new InterfaceFilter(value);
        } else if (type.equals("node")) {
            filter = new NodeFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("notificationIdFilter")) {
            filter = new NotificationIdFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("responder")) {
            filter = new ResponderFilter(value);
        } else if (type.equals("service")) {
            filter = new ServiceFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("user")) {
            filter = new UserFilter(value);
        }
        return filter;
    }
}

