/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.LogUtils;
import org.opennms.web.filter.Filter;
import org.opennms.web.notification.AcknowledgeType;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.SortStyle;
import org.opennms.web.notification.WebNotificationRepository;
import org.opennms.web.notification.filter.NotificationCriteria;
import org.opennms.web.notification.filter.NotificationIdFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcWebNotificationRepository
implements WebNotificationRepository {
    @Autowired
    SimpleJdbcTemplate m_simpleJdbcTemplate;

    private String getSql(String selectClause, NotificationCriteria criteria) {
        final StringBuilder buf = new StringBuilder(selectClause);
        criteria.visit(new NotificationCriteria.NotificationCriteriaVisitor<RuntimeException>(){
            boolean first = true;

            public void and(StringBuilder buf2) {
                if (this.first) {
                    buf2.append(" WHERE ");
                    this.first = false;
                } else {
                    buf2.append(" AND ");
                }
            }

            @Override
            public void visitAckType(AcknowledgeType ackType) throws RuntimeException {
                this.and(buf);
                buf.append(ackType.getAcknowledgeTypeClause());
            }

            @Override
            public void visitFilter(Filter filter) throws RuntimeException {
                this.and(buf);
                buf.append(filter.getParamSql());
            }

            @Override
            public void visitLimit(int limit, int offset) throws RuntimeException {
                buf.append(" LIMIT ").append(limit).append(" OFFSET ").append(offset);
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) throws RuntimeException {
                buf.append(" ");
                buf.append(sortStyle.getOrderByClause());
            }
        });
        return buf.toString();
    }

    private PreparedStatementSetter paramSetter(final NotificationCriteria criteria, final Object ... args) {
        return new PreparedStatementSetter(){
            int paramIndex = 1;

            public void setValues(final PreparedStatement ps) throws SQLException {
                for (Object arg : args) {
                    ps.setObject(this.paramIndex, arg);
                    ++this.paramIndex;
                }
                criteria.visit(new NotificationCriteria.BaseNotificationCriteriaVisitor<SQLException>(){

                    @Override
                    public void visitFilter(Filter filter) throws SQLException {
                        LogUtils.infof((Object)this, (String)("filter sql: " + filter.getSql()), (Object[])new Object[0]);
                        paramIndex += filter.bindParam(ps, paramIndex);
                    }
                });
            }
        };
    }

    @Override
    public void acknowledgeMatchingNotification(String user, Date timestamp, NotificationCriteria criteria) {
        String sql = this.getSql("UPDATE NOTIFICATIONS SET RESPONDTIME=?, ANSWEREDBY=?", criteria);
        this.jdbc().update(sql, this.paramSetter(criteria, new Timestamp(timestamp.getTime()), user));
    }

    @Override
    public Notification[] getMatchingNotifications(NotificationCriteria criteria) {
        String sql = this.getSql("SELECT NOTIFICATIONS.*, SERVICE.SERVICENAME FROM NOTIFICATIONS LEFT OUTER JOIN SERVICE USING (SERVICEID)", criteria);
        return this.getNotifications(sql, this.paramSetter(criteria, new Object[0]));
    }

    private Notification[] getNotifications(String sql, PreparedStatementSetter paramSetter) {
        List<Notification> notifications = this.queryForList(sql, paramSetter, new NotificationMapper());
        return notifications.toArray(new Notification[0]);
    }

    @Override
    public Notification getNotification(int noticeId) {
        Notification[] notifications = this.getMatchingNotifications(new NotificationCriteria(new NotificationIdFilter(noticeId)));
        if (notifications.length < 1) {
            return null;
        }
        return notifications[0];
    }

    @Override
    public int countMatchingNotifications(NotificationCriteria criteria) {
        String sql = this.getSql("SELECT COUNT(*) AS NOTICECOUNT FROM NOTIFICATIONS", criteria);
        return this.queryForInt(sql, this.paramSetter(criteria, new Object[0]));
    }

    private int queryForInt(String sql, PreparedStatementSetter setter) throws DataAccessException {
        Integer number = (Integer)this.queryForObject(sql, setter, (RowMapper)new SingleColumnRowMapper(Integer.class));
        return number != null ? number : 0;
    }

    private <T> T queryForObject(String sql, PreparedStatementSetter setter, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.jdbc().query(sql, setter, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1))));
    }

    private <T> List<T> queryForList(String sql, PreparedStatementSetter setter, ParameterizedRowMapper<T> rm) {
        return (List)this.jdbc().query(sql, setter, (ResultSetExtractor)new RowMapperResultSetExtractor(rm));
    }

    private JdbcOperations jdbc() {
        return this.m_simpleJdbcTemplate.getJdbcOperations();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotificationMapper
    implements ParameterizedRowMapper<Notification> {
        private NotificationMapper() {
        }

        public Notification mapRow(ResultSet rs, int rowNum) throws SQLException {
            Notification notice = new Notification();
            notice.m_notifyID = new Integer(rs.getInt("notifyid"));
            notice.m_timeSent = this.getTimestamp("pagetime", rs);
            notice.m_timeReply = this.getTimestamp("respondtime", rs);
            notice.m_txtMsg = rs.getString("textmsg");
            notice.m_numMsg = rs.getString("numericmsg");
            notice.m_responder = rs.getString("answeredby");
            notice.m_nodeID = new Integer(rs.getInt("nodeid"));
            notice.m_interfaceID = rs.getString("interfaceid");
            notice.m_eventId = new Integer(rs.getInt("eventid"));
            notice.m_serviceName = rs.getString("servicename");
            return notice;
        }

        private long getTimestamp(String field, ResultSet rs) throws SQLException {
            if (rs.getTimestamp(field) != null) {
                return rs.getTimestamp(field).getTime();
            }
            return 0L;
        }
    }
}

