/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.NotificationDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.acknowledgments.AckService;
import org.opennms.web.filter.Filter;
import org.opennms.web.notification.AcknowledgeType;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.SortStyle;
import org.opennms.web.notification.WebNotificationRepository;
import org.opennms.web.notification.filter.NotificationCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DaoWebNotificationRepository
implements WebNotificationRepository {
    @Autowired
    NotificationDao m_notificationDao;
    @Autowired
    AckService m_ackService;

    private OnmsCriteria getOnmsCriteria(NotificationCriteria notificationCriteria) {
        final OnmsCriteria criteria = new OnmsCriteria(OnmsNotification.class);
        criteria.createAlias("node", "node", 1);
        criteria.createAlias("serviceType", "serviceType", 1);
        notificationCriteria.visit(new NotificationCriteria.NotificationCriteriaVisitor<RuntimeException>(){

            @Override
            public void visitAckType(AcknowledgeType ackType) throws RuntimeException {
                if (ackType == AcknowledgeType.ACKNOWLEDGED) {
                    criteria.add(Restrictions.isNotNull((String)"answeredBy"));
                } else if (ackType == AcknowledgeType.UNACKNOWLEDGED) {
                    criteria.add(Restrictions.isNull((String)"answeredBy"));
                }
            }

            public void visitGroupBy() throws RuntimeException {
            }

            @Override
            public void visitFilter(Filter filter) throws RuntimeException {
                criteria.add(filter.getCriterion());
            }

            @Override
            public void visitLimit(int limit, int offset) throws RuntimeException {
                criteria.setMaxResults(Integer.valueOf(limit));
                criteria.setFirstResult(Integer.valueOf(offset));
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) throws RuntimeException {
                switch (sortStyle) {
                    case USER: {
                        criteria.addOrder(Order.desc((String)"user"));
                        break;
                    }
                    case RESPONDER: {
                        criteria.addOrder(Order.desc((String)"responder"));
                        break;
                    }
                    case PAGETIME: {
                        criteria.addOrder(Order.desc((String)"pagetime"));
                        break;
                    }
                    case RESPONDTIME: {
                        criteria.addOrder(Order.desc((String)"respondTime"));
                        break;
                    }
                    case NODE: {
                        criteria.addOrder(Order.desc((String)"nodeId"));
                        break;
                    }
                    case INTERFACE: {
                        criteria.addOrder(Order.desc((String)"interfaceId"));
                        break;
                    }
                    case SERVICE: {
                        criteria.addOrder(Order.desc((String)"serviceId"));
                        break;
                    }
                    case ID: {
                        criteria.addOrder(Order.desc((String)"notifyId"));
                        break;
                    }
                    case REVERSE_USER: {
                        criteria.addOrder(Order.asc((String)"user"));
                        break;
                    }
                    case REVERSE_RESPONDER: {
                        criteria.addOrder(Order.asc((String)"responder"));
                        break;
                    }
                    case REVERSE_PAGETIME: {
                        criteria.addOrder(Order.asc((String)"pagetime"));
                        break;
                    }
                    case REVERSE_RESPONDTIME: {
                        criteria.addOrder(Order.asc((String)"respondTimer"));
                        break;
                    }
                    case REVERSE_NODE: {
                        criteria.addOrder(Order.asc((String)"nodeId"));
                        break;
                    }
                    case REVERSE_INTERFACE: {
                        criteria.addOrder(Order.asc((String)"interfaceId"));
                        break;
                    }
                    case REVERSE_SERVICE: {
                        criteria.addOrder(Order.asc((String)"serviceId"));
                        break;
                    }
                    case REVERSE_ID: {
                        criteria.addOrder(Order.asc((String)"notifyId"));
                    }
                }
            }
        });
        return criteria;
    }

    private Notification mapOnmsNotificationToNotification(OnmsNotification onmsNotification) {
        if (onmsNotification != null) {
            Notification notif = new Notification();
            notif.m_eventId = onmsNotification.getEvent() != null ? onmsNotification.getEvent().getId() : 0;
            notif.m_interfaceID = onmsNotification.getIpAddress();
            notif.m_nodeID = onmsNotification.getNode() != null ? onmsNotification.getNode().getId() : 0;
            notif.m_notifyID = onmsNotification.getNotifyId();
            notif.m_numMsg = onmsNotification.getNumericMsg();
            notif.m_responder = onmsNotification.getAnsweredBy();
            notif.m_serviceId = onmsNotification.getServiceType() != null ? onmsNotification.getServiceType().getId() : 0;
            notif.m_serviceName = onmsNotification.getServiceType() != null ? onmsNotification.getServiceType().getName() : "";
            notif.m_timeReply = onmsNotification.getRespondTime() != null ? onmsNotification.getRespondTime().getTime() : 0L;
            notif.m_timeSent = onmsNotification.getPageTime() != null ? onmsNotification.getPageTime().getTime() : 0L;
            notif.m_txtMsg = onmsNotification.getTextMsg();
            return notif;
        }
        return null;
    }

    @Transactional
    public void acknowledgeMatchingNotification(String user, Date timestamp, NotificationCriteria criteria) {
        List notifs = this.m_notificationDao.findMatching(this.getOnmsCriteria(criteria));
        for (OnmsNotification notif : notifs) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)notif, user);
            ack.setAckAction(AckAction.ACKNOWLEDGE);
            ack.setAckTime(timestamp);
            this.m_ackService.processAck(ack);
        }
    }

    @Transactional
    public int countMatchingNotifications(NotificationCriteria criteria) {
        return this.queryForInt(this.getOnmsCriteria(criteria));
    }

    @Transactional
    public Notification[] getMatchingNotifications(NotificationCriteria criteria) {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        List onmsNotifs = this.m_notificationDao.findMatching(this.getOnmsCriteria(criteria));
        for (OnmsNotification notif : onmsNotifs) {
            notifications.add(this.mapOnmsNotificationToNotification(notif));
        }
        return notifications.toArray(new Notification[0]);
    }

    @Transactional
    public Notification getNotification(int noticeId) {
        return this.mapOnmsNotificationToNotification((OnmsNotification)this.m_notificationDao.get((Serializable)Integer.valueOf(noticeId)));
    }

    private int queryForInt(OnmsCriteria onmsCriteria) {
        return this.m_notificationDao.countMatching(onmsCriteria);
    }
}

