/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.nodelabel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.utils.NodeLabel;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.web.MissingParameterException;
import org.opennms.web.Util;
import org.opennms.web.WebSecurityUtils;

public class NodeLabelChangeServlet
extends HttpServlet {
    private static final long serialVersionUID = -7766362068448931124L;
    protected EventProxy proxy;

    public void init() throws ServletException {
        try {
            this.proxy = Util.createEventProxy();
        }
        catch (Exception e) {
            throw new ServletException("JMS Exception", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodeIdString = request.getParameter("node");
        String labelType = request.getParameter("labeltype");
        String userLabel = request.getParameter("userlabel");
        if (nodeIdString == null) {
            throw new MissingParameterException("node", new String[]{"node", "labeltype", "userlabel"});
        }
        if (labelType == null) {
            throw new MissingParameterException("labeltype", new String[]{"node", "labeltype", "userlabel"});
        }
        if (userLabel == null) {
            throw new MissingParameterException("userlabel", new String[]{"node", "labeltype", "userlabel"});
        }
        try {
            int nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
            NodeLabel oldLabel = NodeLabel.retrieveLabel((int)nodeId);
            NodeLabel newLabel = null;
            if (labelType.equals("auto")) {
                newLabel = NodeLabel.computeLabel((int)nodeId);
            } else if (labelType.equals("user")) {
                newLabel = new NodeLabel(userLabel, 'U');
            } else {
                throw new ServletException("Unexpected labeltype value: " + labelType);
            }
            NodeLabel.assignLabel((int)nodeId, (NodeLabel)newLabel);
            this.sendLabelChangeEvent(nodeId, oldLabel, newLabel);
            response.sendRedirect(Util.calculateUrlBase(request) + "/element/node.jsp?node=" + nodeIdString);
        }
        catch (SQLException e) {
            throw new ServletException("Database exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException("Exception sending node label change event", (Throwable)e);
        }
    }

    protected void sendLabelChangeEvent(int nodeId, NodeLabel oldNodeLabel, NodeLabel newNodeLabel) throws EventProxyException {
        Parm parm;
        Value value;
        Event outEvent = new Event();
        outEvent.setSource("NodeLabelChangeServlet");
        outEvent.setUei("uei.opennms.org/nodes/nodeLabelChanged");
        outEvent.setNodeid((long)nodeId);
        outEvent.setHost("host");
        outEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms parms = new Parms();
        if (oldNodeLabel != null) {
            value = new Value();
            value.setContent(oldNodeLabel.getLabel());
            parm = new Parm();
            parm.setParmName("oldNodeLabel");
            parm.setValue(value);
            parms.addParm(parm);
            value = new Value();
            value.setContent(String.valueOf(oldNodeLabel.getSource()));
            parm = new Parm();
            parm.setParmName("oldNodeLabelSource");
            parm.setValue(value);
            parms.addParm(parm);
        }
        if (newNodeLabel != null) {
            value = new Value();
            value.setContent(newNodeLabel.getLabel());
            parm = new Parm();
            parm.setParmName("newNodeLabel");
            parm.setValue(value);
            parms.addParm(parm);
            value = new Value();
            value.setContent(String.valueOf(newNodeLabel.getSource()));
            parm = new Parm();
            parm.setParmName("newNodeLabelSource");
            parm.setValue(value);
            parms.addParm(parm);
        }
        outEvent.setParms(parms);
        this.proxy.send(outEvent);
    }
}

