/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.view;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.opennms.web.map.db.DbMap;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VMap
extends DbMap {
    Hashtable<String, VElement> elements = new Hashtable();
    List<VLink> links = new ArrayList<VLink>();
    String createTimeString;
    String lastModifiedTimeString;

    public VMap(String mapName) {
        super.setName(mapName);
    }

    public VMap(int id, String name, String background, String owner, String accessMode, String userLastModifies, float scale, int offsetX, int offsetY, String type, int width, int height) {
        super(id, name, background, owner, accessMode, userLastModifies, scale, offsetX, offsetY, type, width, height);
    }

    public void addElement(VElement ve) {
        if (ve != null) {
            this.elements.put(this.getElementId(ve), ve);
            ve.setMapId(this.getId());
        }
    }

    public void addElements(VElement[] ve) {
        if (ve != null) {
            for (int i = 0; i < ve.length; ++i) {
                this.addElement(ve[i]);
            }
        }
    }

    public void addElements(List<VElement> elems) {
        if (elems != null) {
            for (VElement elem : elems) {
                this.addElement(elem);
            }
        }
    }

    public void addLink(VLink link) {
        this.links.add(link);
    }

    public void addLinks(List<VLink> links) {
        this.links.addAll(links);
    }

    public VElement removeElement(int id, String type) {
        VElement ve = this.elements.remove(this.getElementId(id, type));
        if (ve != null) {
            ve.isChild = false;
        }
        return ve;
    }

    public VLink removeLink(VLink link) {
        int index = this.links.indexOf(link);
        return this.links.remove(index);
    }

    public List<VLink> getLinksOnElement(int id, String type) {
        ArrayList<VLink> lns = new ArrayList<VLink>();
        for (VLink vlink : this.links) {
            if (vlink.getId().indexOf(this.getElementId(id, type)) == -1) continue;
            lns.add(vlink);
        }
        return lns;
    }

    public List<VLink> removeLinksOnElementList(int id, String type) {
        ArrayList<VLink> links = new ArrayList<VLink>();
        for (VLink vlink : this.getLinksOnElement(id, type)) {
            links.add(this.removeLink(vlink));
        }
        return links;
    }

    public void removeElements(int[] ids, String type) {
        if (ids != null) {
            for (int id : ids) {
                this.removeElement(id, type);
            }
        }
    }

    public VElement getElement(int id, String type) {
        return this.elements.get(this.getElementId(id, type));
    }

    public Map<String, VElement> getElements() {
        return this.elements;
    }

    public List<VLink> getLinks() {
        return this.links;
    }

    public void removeAllElements() {
        this.elements.clear();
    }

    public void removeAllLinks() {
        this.links.clear();
    }

    public int size() {
        return this.elements.size();
    }

    public int linksize() {
        return this.links.size();
    }

    public boolean containsElement(int id, String type) {
        return this.elements.containsKey(this.getElementId(id, type));
    }

    public boolean containsLink(VLink link) {
        return this.links.contains(link);
    }

    @Override
    public void setAccessMode(String accessMode) {
        super.setAccessMode(accessMode);
    }

    @Override
    public void setBackground(String background) {
        super.setBackground(background);
    }

    @Override
    public void setCreateTime(Timestamp createTime) {
        super.setCreateTime(createTime);
    }

    @Override
    public void setLastModifiedTime(Timestamp lastModifiedTime) {
        super.setLastModifiedTime(lastModifiedTime);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setOffsetX(int offsetX) {
        super.setOffsetX(offsetX);
    }

    @Override
    public void setOffsetY(int offsetY) {
        super.setOffsetY(offsetY);
    }

    @Override
    public void setOwner(String owner) {
        super.setOwner(owner);
    }

    @Override
    public void setScale(float scale) {
        super.setScale(scale);
    }

    @Override
    public void setType(String type) {
        super.setType(type);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
    }

    @Override
    public void setUserLastModifies(String userLastModifies) {
        super.setUserLastModifies(userLastModifies);
    }

    @Override
    public boolean isNew() {
        return super.isNew();
    }

    private String getElementId(VElement element) {
        return element.getId() + element.getType();
    }

    private String getElementId(int id, String type) {
        return id + type;
    }

    public String getCreateTimeString() {
        return this.createTimeString;
    }

    public void setCreateTimeString(String createTimeString) {
        this.createTimeString = createTimeString;
    }

    public String getLastModifiedTimeString() {
        return this.lastModifiedTimeString;
    }

    public void setLastModifiedTimeString(String lastModifiedTimeString) {
        this.lastModifiedTimeString = lastModifiedTimeString;
    }
}

