/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.view;

import org.opennms.web.map.MapsException;
import org.opennms.web.map.db.DbElement;
import org.opennms.web.map.view.VElementNotChildException;

public class VElement
extends DbElement {
    protected boolean isChild = false;
    protected int status = 0;
    protected int severity = 0;
    protected double avail = 0.0;

    public VElement() {
    }

    public VElement(DbElement e) throws MapsException {
        super(e);
    }

    public VElement(int mapId, int id, String type, String iconName, String label, int x, int y) throws MapsException {
        super(mapId, id, type, label, iconName, x, y);
        this.isChild = true;
    }

    public VElement(int mapId, int id, String type, String label, String iconName) throws MapsException {
        super(mapId, id, type, label, iconName, 0, 0);
        this.isChild = true;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public double getAvail() {
        return this.avail;
    }

    public void setAvail(double rtc) {
        this.avail = rtc;
    }

    public boolean isChild() {
        return this.isChild;
    }

    public boolean equals(Object other) {
        return this.equalsIgnorePosition((VElement)other);
    }

    public boolean equalsIgnorePosition(VElement elem) {
        return this.getMapId() == elem.getMapId() && this.getId() == elem.getId() && this.type.equals(elem.getType()) && this.avail == elem.getAvail() && this.status == elem.getStatus() && this.severity == elem.getSeverity() && this.getLabel().equals(elem.getLabel());
    }

    public boolean equalsIgnorePositionParentMap(VElement elem) {
        return this.getId() == elem.getId() && this.type.equals(elem.getType()) && this.avail == elem.getAvail() && this.status == elem.getStatus() && this.severity == elem.getSeverity() && this.getLabel().equals(elem.getLabel());
    }

    public boolean hasSameIdentifier(VElement elem) {
        return this.getId() == elem.getId() && this.type.equals(elem.getType());
    }

    public void setMapId(int mapId) {
        super.setMapId(mapId);
        this.isChild = true;
    }

    public final int getContainerMap() throws VElementNotChildException {
        if (this.isChild) {
            return this.getMapId();
        }
        throw new VElementNotChildException();
    }

    public String toString() {
        return this.getId() + this.getType();
    }

    public VElement clone() {
        return (VElement)super.clone();
    }
}

