/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.opennms.core.resource.Vault;
import org.opennms.core.resource.db.DbConnectionFactory;
import org.opennms.core.resource.db.SimpleDbConnectionFactory;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.map.MapsException;
import org.opennms.web.map.db.DbElement;
import org.opennms.web.map.db.DbMap;
import org.opennms.web.map.db.LinkInfo;
import org.opennms.web.map.db.Manager;
import org.opennms.web.map.view.VElementInfo;
import org.opennms.web.map.view.VMapInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBManager
extends Manager {
    String mapTable = "map";
    String elementTable = "element";
    ThreadCategory log = null;
    private DbConnectionFactory m_factory = null;

    public DBManager() throws MapsException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Instantiating DBManager (using Vault)");
        }
    }

    public DBManager(Map<String, String> params) throws MapsException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Instantiating DBManager with params: " + params);
        }
        String url = params.get("url");
        String driver = params.get("driver");
        String user = params.get("user");
        String password = params.get("password");
        this.m_factory = new SimpleDbConnectionFactory();
        try {
            this.m_factory.init(url, driver, user, password);
        }
        catch (Exception e) {
            throw new MapsException("Error while initializing dbconnection factory", e);
        }
    }

    Connection createConnection() throws MapsException {
        if (this.m_factory != null) {
            try {
                return this.m_factory.getConnection();
            }
            catch (SQLException e) {
                this.log.error("Exception while creating connection");
                throw new MapsException(e);
            }
        }
        try {
            return Vault.getDbConnection();
        }
        catch (SQLException e) {
            this.log.error("Exception while creating connection");
            throw new MapsException(e);
        }
    }

    void releaseConnection(Connection conn) throws MapsException {
        try {
            if (conn != null && !conn.isClosed()) {
                if (this.m_factory != null) {
                    conn.close();
                } else {
                    Vault.releaseDbConnection((Connection)conn);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Exception while releasing connection");
            throw new MapsException(e);
        }
    }

    public void finalize(Connection conn) throws MapsException {
        this.log.debug("finalizing...");
        try {
            this.releaseConnection(conn);
        }
        catch (Exception e) {
            this.log.error("Exception while finalizing", (Throwable)e);
            throw new MapsException(e);
        }
    }

    private Connection startSession() throws MapsException {
        try {
            Connection conn = this.createConnection();
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(2);
            return conn;
        }
        catch (Exception e) {
            this.log.error("error while starting session");
            throw new MapsException(e);
        }
    }

    private synchronized void endSession(Connection conn) throws MapsException {
        try {
            conn.commit();
            conn.setAutoCommit(true);
            this.releaseConnection(conn);
        }
        catch (Exception e) {
            this.log.error("error while ending session");
            throw new MapsException(e);
        }
    }

    private void rollback(Connection conn) throws MapsException {
        try {
            conn.rollback();
        }
        catch (SQLException ex) {
            this.log.error("Error while rollback");
            throw new MapsException(ex);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public synchronized int saveMap(DbMap m, Collection<DbElement> e) throws MapsException {
        this.log.debug("saving map...");
        Connection conn = this.startSession();
        String sqlGetCurrentTimestamp = "SELECT CURRENT_TIMESTAMP";
        String sqlGetMapNxtId = "SELECT nextval('mapnxtid')";
        String sqlInsertQuery = "INSERT INTO " + this.mapTable + " (mapid, mapname, mapbackground, mapowner, mapcreatetime, mapaccess, userlastmodifies, lastmodifiedtime, mapscale, mapxoffset, mapyoffset, maptype, mapwidth, mapheight) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String sqlUpdateQuery = "UPDATE " + this.mapTable + " SET mapname = ?, mapbackground = ?, mapowner = ?, mapaccess = ?, userlastmodifies = ?, lastmodifiedtime = ?, mapscale = ?, mapxoffset = ?, mapyoffset = ?, maptype = ? , mapwidth = ?, mapheight = ? WHERE mapid = ?";
        Timestamp currentTimestamp = null;
        int nxtid = 0;
        int count = -1;
        try {
            Statement stmtCT = conn.createStatement();
            ResultSet rs = stmtCT.executeQuery("SELECT CURRENT_TIMESTAMP");
            if (rs.next()) {
                PreparedStatement statement;
                currentTimestamp = rs.getTimestamp(1);
                if (m.isNew()) {
                    Statement stmtID = conn.createStatement();
                    ResultSet rsStmt = stmtID.executeQuery("SELECT nextval('mapnxtid')");
                    if (rsStmt.next()) {
                        nxtid = rsStmt.getInt(1);
                    }
                    rsStmt.close();
                    stmtID.close();
                    statement = conn.prepareStatement(sqlInsertQuery);
                    statement.setInt(1, nxtid);
                    statement.setString(2, m.getName());
                    statement.setString(3, m.getBackground());
                    statement.setString(4, m.getOwner());
                    statement.setTimestamp(5, currentTimestamp);
                    statement.setString(6, m.getAccessMode());
                    statement.setString(7, m.getUserLastModifies());
                    statement.setTimestamp(8, currentTimestamp);
                    statement.setDouble(9, m.getScale());
                    statement.setInt(10, m.getOffsetX());
                    statement.setInt(11, m.getOffsetY());
                    statement.setString(12, m.getType());
                    statement.setInt(13, m.getWidth());
                    statement.setInt(14, m.getHeight());
                } else {
                    statement = conn.prepareStatement(sqlUpdateQuery);
                    statement.setString(1, m.getName());
                    statement.setString(2, m.getBackground());
                    statement.setString(3, m.getOwner());
                    statement.setString(4, m.getAccessMode());
                    statement.setString(5, m.getUserLastModifies());
                    statement.setTimestamp(6, currentTimestamp);
                    statement.setDouble(7, m.getScale());
                    statement.setInt(8, m.getOffsetX());
                    statement.setInt(9, m.getOffsetY());
                    statement.setString(10, m.getType());
                    statement.setInt(11, m.getWidth());
                    statement.setInt(12, m.getHeight());
                    statement.setInt(13, m.getId());
                }
                count = statement.executeUpdate();
                if (count == 0) {
                    this.log.warn("Called saveMap() on deleted map");
                    throw new MapsException("Called saveMap() on deleted map");
                }
                if (m.isNew()) {
                    for (DbElement dbe : e) {
                        dbe.setMapId(nxtid);
                        this.saveElementInSession(dbe, conn);
                    }
                } else {
                    this.deleteElementsOfMapInSession(m.getId(), conn);
                    for (DbElement dbe : e) {
                        this.saveElementInSession(dbe, conn);
                    }
                }
                statement.close();
            }
            rs.close();
            stmtCT.close();
        }
        catch (SQLException ex) {
            this.log.error("Error while saving map");
            this.rollback(conn);
            throw new MapsException("Error while saving map " + m.getId(), ex);
        }
        finally {
            this.endSession(conn);
        }
        if (m.isNew()) {
            return nxtid;
        }
        return m.getId();
    }

    private synchronized void saveElementInSession(DbElement e, Connection conn) throws MapsException {
        this.log.debug("saving element: " + e.getId() + e.getType());
        String sqlSelectQuery = "SELECT COUNT(*) FROM " + this.elementTable + " WHERE elementid = ? AND MAPID = ? AND elementtype = ?";
        String sqlInsertQuery = "INSERT INTO " + this.elementTable + " (mapid, elementid, elementtype, elementlabel, elementicon, elementx, elementy) VALUES (?, ?, ?, ?, ?, ?, ?)";
        String sqlUpdateQuery = "UPDATE " + this.elementTable + " SET mapid = ?, elementid = ?, elementtype = ?, elementlabel = ?, elementicon = ?, elementx = ?, elementy = ? WHERE elementid = ? AND mapid = ? AND elementtype = ?";
        try {
            PreparedStatement statement = conn.prepareStatement(sqlSelectQuery);
            statement.setInt(1, e.getId());
            statement.setInt(2, e.getMapId());
            statement.setString(3, e.getType());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                statement.close();
                if (count == 0) {
                    statement = conn.prepareStatement(sqlInsertQuery);
                    statement.setInt(1, e.getMapId());
                    statement.setInt(2, e.getId());
                    statement.setString(3, e.getType());
                    statement.setString(4, e.getLabel());
                    statement.setString(5, e.getIcon());
                    statement.setInt(6, e.getX());
                    statement.setInt(7, e.getY());
                } else {
                    statement = conn.prepareStatement(sqlUpdateQuery);
                    statement.setInt(1, e.getMapId());
                    statement.setInt(2, e.getId());
                    statement.setString(3, e.getType());
                    statement.setString(4, e.getLabel());
                    statement.setString(5, e.getIcon());
                    statement.setInt(6, e.getX());
                    statement.setInt(7, e.getY());
                    statement.setInt(8, e.getId());
                    statement.setInt(9, e.getMapId());
                    statement.setString(10, e.getType());
                }
                count = statement.executeUpdate();
                rs.close();
                statement.close();
            }
        }
        catch (SQLException ex) {
            this.log.error("error while saving element");
            throw new MapsException(ex);
        }
    }

    public synchronized void saveElement(DbElement e) throws MapsException {
        this.log.debug("saving element");
        Connection conn = this.startSession();
        String sqlSelectQuery = "SELECT COUNT(*) FROM " + this.elementTable + " WHERE elementid = ? AND MAPID = ? AND elementtype = ?";
        String sqlInsertQuery = "INSERT INTO " + this.elementTable + " (mapid, elementid, elementtype, elementlabel, elementicon, elementx, elementy) VALUES (?, ?, ?, ?, ?, ?, ?)";
        String sqlUpdateQuery = "UPDATE " + this.elementTable + " SET mapid = ?, elementid = ?, elementtype = ?, elementlabel = ?, elementicon = ?, elementx = ?, elementy = ? WHERE elementid = ? AND mapid = ? AND elementtype = ?";
        try {
            PreparedStatement statement = conn.prepareStatement(sqlSelectQuery);
            statement.setInt(1, e.getId());
            statement.setInt(2, e.getMapId());
            statement.setString(3, e.getType());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                statement.close();
                if (count == 0) {
                    statement = conn.prepareStatement(sqlInsertQuery);
                    statement.setInt(1, e.getMapId());
                    statement.setInt(2, e.getId());
                    statement.setString(3, e.getType());
                    statement.setString(4, e.getLabel());
                    statement.setString(5, e.getIcon());
                    statement.setInt(6, e.getX());
                    statement.setInt(7, e.getY());
                } else {
                    statement = conn.prepareStatement(sqlUpdateQuery);
                    statement.setInt(1, e.getMapId());
                    statement.setInt(2, e.getId());
                    statement.setString(3, e.getType());
                    statement.setString(4, e.getLabel());
                    statement.setString(5, e.getIcon());
                    statement.setInt(6, e.getX());
                    statement.setInt(7, e.getY());
                    statement.setInt(8, e.getId());
                    statement.setInt(9, e.getMapId());
                    statement.setString(10, e.getType());
                }
                count = statement.executeUpdate();
                rs.close();
                statement.close();
            }
        }
        catch (SQLException ex) {
            this.log.error("error while saving element");
            this.rollback(conn);
            throw new MapsException(ex);
        }
        finally {
            this.endSession(conn);
        }
    }

    public synchronized void deleteElements(DbElement[] elems) throws MapsException {
        this.log.debug("deleting elements...");
        Connection conn = this.startSession();
        try {
            if (elems != null) {
                for (int i = 0; i < elems.length; ++i) {
                    this.deleteElementInSession(elems[i].getId(), elems[i].getMapId(), elems[i].getType());
                }
            }
        }
        catch (MapsException e) {
            this.log.error("Error while deleting elements");
            this.rollback(conn);
            throw e;
        }
        finally {
            this.endSession(conn);
        }
    }

    public synchronized void deleteElement(DbElement e) throws MapsException {
        this.log.debug("deleting element...");
        if (e != null) {
            this.deleteElement(e.getId(), e.getMapId(), e.getType());
        }
    }

    private synchronized void deleteElementInSession(int id, int mapid, String type) throws MapsException {
        this.log.debug("deleting element...");
        Connection conn = this.startSession();
        String sqlDelete = "DELETE FROM " + this.elementTable + " WHERE elementid = ? AND mapid = ? AND elementtype = ?";
        try {
            PreparedStatement statement = conn.prepareStatement(sqlDelete);
            statement.setInt(1, id);
            statement.setInt(2, mapid);
            statement.setString(3, type);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            this.log.error("error while deleting element...");
            this.rollback(conn);
            throw new MapsException(e);
        }
        finally {
            this.endSession(conn);
        }
    }

    public synchronized void deleteElement(int id, int mapid, String type) throws MapsException {
        this.log.debug("deleting element...");
        Connection conn = this.startSession();
        String sqlDelete = "DELETE FROM " + this.elementTable + " WHERE elementid = ? AND mapid = ? AND elementtype = ?";
        try {
            PreparedStatement statement = conn.prepareStatement(sqlDelete);
            statement.setInt(1, id);
            statement.setInt(2, mapid);
            statement.setString(3, type);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            this.log.error("error while deleting element...", (Throwable)e);
            this.rollback(conn);
            throw new MapsException(e);
        }
        finally {
            this.endSession(conn);
        }
    }

    private synchronized void deleteElementsOfMapInSession(int id, Connection conn) throws MapsException {
        this.log.debug("deleting elements of map...");
        String sqlDelete = "DELETE FROM " + this.elementTable + " WHERE mapid = ?";
        try {
            PreparedStatement statement = conn.prepareStatement(sqlDelete);
            statement.setInt(1, id);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            this.log.error("Error while deleting elements of map " + id);
            this.rollback(conn);
            throw new MapsException(e);
        }
    }

    @Override
    public synchronized int deleteMap(int id) throws MapsException {
        this.log.debug("deleting map...");
        Connection conn = this.startSession();
        String sqlDeleteMap = "DELETE FROM " + this.mapTable + " WHERE mapid = ? AND maptype != ? ";
        int countDelete = 0;
        try {
            PreparedStatement statement = conn.prepareStatement(sqlDeleteMap);
            statement.setInt(1, id);
            statement.setString(2, "A");
            countDelete = statement.executeUpdate();
            statement.close();
            int n = countDelete;
            return n;
        }
        catch (SQLException e) {
            this.log.error("error while deleting map " + id);
            this.rollback(conn);
            throw new MapsException(e);
        }
        finally {
            this.endSession(conn);
        }
    }

    @Override
    public synchronized void deleteNodeTypeElementsFromAllMaps() throws MapsException {
        this.log.debug("deleting all node elements...");
        Connection conn = this.startSession();
        String sqlDelete = "DELETE FROM " + this.elementTable + " WHERE elementtype = ?";
        try {
            PreparedStatement statement = conn.prepareStatement(sqlDelete);
            statement.setString(1, "N");
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            this.log.error("error while deleting all node elements");
            this.rollback(conn);
            throw new MapsException(e);
        }
        finally {
            this.endSession(conn);
        }
    }

    @Override
    public synchronized void deleteMapTypeElementsFromAllMaps() throws MapsException {
        this.log.debug("deleting all map elements...");
        Connection conn = this.startSession();
        String sqlDelete = "DELETE FROM " + this.elementTable + " WHERE elementtype = ?";
        try {
            PreparedStatement statement = conn.prepareStatement(sqlDelete);
            statement.setString(1, "M");
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            this.log.error("error while deleting all map elements");
            this.rollback(conn);
            throw new MapsException(e);
        }
        finally {
            this.endSession(conn);
        }
    }

    @Override
    public DbElement getElement(int id, int mapId, String type) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.elementTable + " WHERE elementid = ? AND mapid = ? and elementtype = ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, id);
            statement.setInt(2, mapId);
            statement.setString(3, type);
            ResultSet rs = statement.executeQuery();
            DbElement el = this.rs2Element(rs);
            rs.close();
            statement.close();
            DbElement dbElement = el;
            return dbElement;
        }
        catch (Exception e) {
            this.log.error("Exception while getting element with elementid=" + id + " and mapid=" + mapId);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbElement newElement(int id, int mapId, String type) throws MapsException {
        DbElement e = new DbElement(mapId, id, type, null, null, 0, 0);
        e = this.completeElement(e);
        this.log.debug("Creating new VElement mapId:" + mapId + " id:" + id + " type:" + type + " label:" + e.getLabel() + " iconname:" + e.getIcon() + " x:" + 0 + " y:" + 0);
        return e;
    }

    private DbElement completeElement(DbElement e) throws MapsException {
        Connection conn = this.createConnection();
        String sqlQuery = null;
        try {
            sqlQuery = e.getType().equals("M") ? "SELECT mapname FROM " + this.mapTable + " WHERE mapId = ?" : "SELECT nodelabel,nodesysoid FROM node WHERE nodeid = ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, e.getId());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                e.setLabel(this.getLabel(rs.getString(1)));
                if (e.getType().equals("N") && rs.getString(2) != null) {
                    this.log.debug("DBManager: sysoid = " + rs.getString(2));
                    e.setSysoid(rs.getString(2));
                }
            }
            rs.close();
            statement.close();
        }
        catch (Exception e1) {
            this.log.error("Error while completing element (" + e.getId() + ") with label and icon ", (Throwable)e1);
            throw new MapsException(e1);
        }
        finally {
            this.releaseConnection(conn);
        }
        return e;
    }

    @Override
    public DbElement[] getAllElements() throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.elementTable;
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlQuery);
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            rs.close();
            statement.close();
            if (elements == null) {
                DbElement[] dbElementArray = new DbElement[]{};
                return dbElementArray;
            }
            DbElement[] el = new DbElement[elements.size()];
            DbElement[] dbElementArray = el = elements.toArray(el);
            return dbElementArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting all elements");
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbElement[] getElementsOfMap(int mapid) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.elementTable + " WHERE mapid = ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, mapid);
            ResultSet rs = statement.executeQuery();
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            DbElement[] el = null;
            if (elements != null) {
                el = new DbElement[elements.size()];
                el = elements.toArray(el);
            }
            rs.close();
            statement.close();
            DbElement[] dbElementArray = el;
            return dbElementArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting elements of map with mapid=" + mapid);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbElement[] getNodeElementsOfMap(int mapid) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.elementTable + " WHERE mapid = ? AND elementtype = 'N' ";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, mapid);
            ResultSet rs = statement.executeQuery();
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            DbElement[] el = null;
            if (elements != null) {
                el = new DbElement[elements.size()];
                el = elements.toArray(el);
            }
            rs.close();
            statement.close();
            DbElement[] dbElementArray = el;
            return dbElementArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting element node of map with mapid " + mapid);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbElement[] getMapElementsOfMap(int mapid) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.elementTable + " WHERE mapid = ? AND elementtype = 'M' ";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, mapid);
            ResultSet rs = statement.executeQuery();
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            DbElement[] el = null;
            if (elements != null) {
                el = new DbElement[elements.size()];
                el = elements.toArray(el);
            }
            rs.close();
            statement.close();
            DbElement[] dbElementArray = el;
            return dbElementArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting map element of map with mapid " + mapid);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbElement[] getElementsLike(String elementLabel) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.elementTable + " WHERE elementlabel LIKE ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            elementLabel = "%" + elementLabel + "%";
            statement.setString(1, elementLabel);
            ResultSet rs = statement.executeQuery();
            Vector<DbElement> elements = this.rs2ElementVector(rs);
            DbElement[] el = new DbElement[elements.size()];
            el = elements.toArray(el);
            rs.close();
            statement.close();
            DbElement[] dbElementArray = el;
            return dbElementArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting elements by label like " + elementLabel);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public Map<Integer, Set<Integer>> getMapsStructure() throws MapsException {
        Connection conn = this.createConnection();
        try {
            HashMap<Integer, Set<Integer>> maps = new HashMap<Integer, Set<Integer>>();
            String sqlQuery = "select elementid,mapid from " + this.elementTable + " where elementtype=?";
            PreparedStatement ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, "M");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Integer parentId = new Integer(rs.getInt("mapid"));
                Integer childId = new Integer(rs.getInt("elementid"));
                HashSet<Integer> childs = (HashSet<Integer>)maps.get(parentId);
                if (childs == null) {
                    childs = new HashSet<Integer>();
                }
                if (!childs.contains(childId)) {
                    childs.add(childId);
                }
                maps.put(parentId, childs);
            }
            HashMap<Integer, Set<Integer>> hashMap = maps;
            return hashMap;
        }
        catch (Exception e) {
            this.log.error("Exception while getting maps parent-child structure");
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public int countMaps(int mapId) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT COUNT(*) FROM " + this.mapTable + " WHERE mapid = ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, mapId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            statement.close();
            int n = count;
            return n;
        }
        catch (Exception e) {
            this.log.error("Exception while counting maps");
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbMap getMap(int id) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.mapTable + " WHERE mapId = ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, id);
            ResultSet rs = statement.executeQuery();
            DbMap map = this.rs2Map(rs);
            rs.close();
            statement.close();
            DbMap dbMap = map;
            return dbMap;
        }
        catch (Exception e) {
            this.log.error("Exception while getting map with mapid=" + id);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbMap[] getMaps(String mapname, String maptype) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.mapTable + " WHERE mapName= ? AND maptype = ? ";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setString(1, mapname);
            statement.setString(2, maptype);
            ResultSet rs = statement.executeQuery();
            Vector<DbMap> maps = this.rs2MapVector(rs);
            DbMap[] el = null;
            if (maps != null) {
                el = new DbMap[maps.size()];
                el = maps.toArray(el);
            }
            rs.close();
            statement.close();
            DbMap[] dbMapArray = el;
            return dbMapArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting maps with name=" + mapname + " and type=" + maptype);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbMap[] getAllMaps() throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.mapTable;
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlQuery);
            Vector<DbMap> maps = this.rs2MapVector(rs);
            DbMap[] el = null;
            if (maps != null) {
                el = new DbMap[maps.size()];
                el = maps.toArray(el);
            }
            rs.close();
            statement.close();
            DbMap[] dbMapArray = el;
            return dbMapArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting all Maps");
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbMap[] getMapsLike(String mapLabel) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.mapTable + " WHERE mapname LIKE ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            mapLabel = "%" + mapLabel + "%";
            statement.setString(1, mapLabel);
            ResultSet rs = statement.executeQuery();
            Vector<DbMap> mapVector = this.rs2MapVector(rs);
            DbMap[] maps = null;
            if (mapVector != null) {
                maps = new DbMap[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            rs.close();
            statement.close();
            DbMap[] dbMapArray = maps;
            return dbMapArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting maps by label like " + mapLabel);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbMap[] getMapsByName(String mapLabel) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT * FROM " + this.mapTable + " WHERE mapname = ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setString(1, mapLabel);
            ResultSet rs = statement.executeQuery();
            Vector<DbMap> mapVector = this.rs2MapVector(rs);
            DbMap[] maps = null;
            if (mapVector != null) {
                maps = new DbMap[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            rs.close();
            statement.close();
            DbMap[] dbMapArray = maps;
            return dbMapArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting elements with label " + mapLabel);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public DbMap[] getContainerMaps(int id, String type) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT " + this.mapTable + ".* FROM " + this.mapTable + " INNER JOIN " + this.elementTable + " ON " + this.mapTable + ".mapid = " + this.elementTable + ".mapid WHERE elementid = ? AND elementtype = ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, id);
            statement.setString(2, type);
            ResultSet rs = statement.executeQuery();
            Vector<DbMap> el = this.rs2MapVector(rs);
            DbMap[] maps = new DbMap[el.size()];
            maps = el.toArray(maps);
            rs.close();
            statement.close();
            DbMap[] dbMapArray = maps;
            return dbMapArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting container maps of element with id/type " + id + "/" + type);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public VMapInfo[] getAllMapMenus() throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM " + this.mapTable + " order by mapname";
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlQuery);
            Vector<VMapInfo> maps = this.rs2MapMenuVector(rs);
            VMapInfo[] el = null;
            if (maps != null) {
                el = new VMapInfo[maps.size()];
                el = maps.toArray(el);
            }
            rs.close();
            statement.close();
            VMapInfo[] vMapInfoArray = el;
            return vMapInfoArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting all map-menu");
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public VMapInfo getMapMenu(int mapId) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM " + this.mapTable + " where mapId= ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, mapId);
            ResultSet rs = statement.executeQuery();
            VMapInfo mm = this.rs2MapMenu(rs);
            rs.close();
            statement.close();
            VMapInfo vMapInfo = mm;
            return vMapInfo;
        }
        catch (Exception e) {
            this.log.error("Exception while getting map-menu for mapid " + mapId);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public VMapInfo[] getMapsMenuByName(String mapLabel) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM " + this.mapTable + " WHERE upper( mapname ) = upper( ? )";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setString(1, mapLabel);
            ResultSet rs = statement.executeQuery();
            Vector<VMapInfo> mapVector = this.rs2MapMenuVector(rs);
            VMapInfo[] maps = null;
            if (mapVector != null) {
                maps = new VMapInfo[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            rs.close();
            statement.close();
            VMapInfo[] vMapInfoArray = maps;
            return vMapInfoArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting all map-menu for map named " + mapLabel);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public VMapInfo[] getMapsMenuByOwner(String owner) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM " + this.mapTable + " WHERE upper( mapowner ) = upper( ? ) and " + "upper( mapaccess ) = upper( ? )";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setString(1, owner);
            statement.setString(2, "RWRO");
            ResultSet rs = statement.executeQuery();
            Vector<VMapInfo> mapVector = this.rs2MapMenuVector(rs);
            VMapInfo[] maps = null;
            if (mapVector != null) {
                maps = new VMapInfo[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            rs.close();
            statement.close();
            VMapInfo[] vMapInfoArray = maps;
            return vMapInfoArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting all map-menu for owner " + owner);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public VMapInfo[] getMapsMenuByGroup(String group) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM " + this.mapTable + " WHERE upper( mapgroup ) = upper( ? ) and " + "upper( mapaccess ) = upper( ? )";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setString(1, group);
            statement.setString(2, "RWRO");
            ResultSet rs = statement.executeQuery();
            Vector<VMapInfo> mapVector = this.rs2MapMenuVector(rs);
            VMapInfo[] maps = null;
            if (mapVector != null) {
                maps = new VMapInfo[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            rs.close();
            statement.close();
            VMapInfo[] vMapInfoArray = maps;
            return vMapInfoArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting all map-menu for group " + group);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public VMapInfo[] getMapsMenuByOther() throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT mapid,mapname,mapowner FROM " + this.mapTable + " WHERE upper( mapaccess ) = upper( ? ) or " + "upper( mapaccess ) = upper( ? )";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setString(1, "RW");
            statement.setString(2, "RO");
            ResultSet rs = statement.executeQuery();
            Vector<VMapInfo> mapVector = this.rs2MapMenuVector(rs);
            VMapInfo[] maps = null;
            if (mapVector != null) {
                maps = new VMapInfo[mapVector.size()];
                maps = mapVector.toArray(maps);
            }
            rs.close();
            statement.close();
            VMapInfo[] vMapInfoArray = maps;
            return vMapInfoArray;
        }
        catch (Exception e) {
            this.log.error("Exception while getting other map for access ");
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public boolean isElementInMap(int elementId, int mapId, String type) throws MapsException {
        try {
            DbElement element = null;
            element = this.getElement(elementId, mapId, type);
            return element != null;
        }
        catch (Exception e) {
            throw new MapsException(e);
        }
    }

    @Override
    public Vector<VElementInfo> getAllElementInfo() throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT  n.nodeid,n.nodelabel,i.ipaddr FROM node n left join ipinterface i on n.nodeid=i.nodeid WHERE n.nodetype!='D' and (i.issnmpprimary='P' or i.issnmpprimary='N') order by nodeid,issnmpprimary desc";
            PreparedStatement statement = conn.prepareStatement("SELECT  n.nodeid,n.nodelabel,i.ipaddr FROM node n left join ipinterface i on n.nodeid=i.nodeid WHERE n.nodetype!='D' and (i.issnmpprimary='P' or i.issnmpprimary='N') order by nodeid,issnmpprimary desc");
            ResultSet rs = statement.executeQuery();
            Vector<VElementInfo> elements = new Vector<VElementInfo>();
            int previousNodeid = -1;
            while (rs.next()) {
                int curnodeid = rs.getInt("nodeid");
                if (curnodeid != previousNodeid) {
                    VElementInfo ei = new VElementInfo(curnodeid, rs.getString("ipaddr"), rs.getString("nodelabel"));
                    elements.add(ei);
                }
                previousNodeid = curnodeid;
            }
            rs.close();
            statement.close();
            Vector<VElementInfo> vector = elements;
            return vector;
        }
        catch (Exception e) {
            this.log.error("Exception while getting all element infos", (Throwable)e);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public List<VElementInfo> getAlarmedElements() throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "select nodeid, eventuei,severity from alarms where nodeid is not null and severity > 3 order by nodeid, lasteventtime desc";
            PreparedStatement statement = conn.prepareStatement("select nodeid, eventuei,severity from alarms where nodeid is not null and severity > 3 order by nodeid, lasteventtime desc");
            ResultSet rs = statement.executeQuery();
            ArrayList<VElementInfo> elems = new ArrayList<VElementInfo>();
            while (rs.next()) {
                VElementInfo einfo = new VElementInfo(rs.getInt(1), rs.getString(2), rs.getInt(3));
                elems.add(einfo);
            }
            rs.close();
            statement.close();
            ArrayList<VElementInfo> arrayList = elems;
            return arrayList;
        }
        catch (Exception e) {
            this.log.error("Exception while getting outaged elements");
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public Map<Integer, Double> getAvails(DbElement[] mapElements) throws MapsException {
        Map<Integer, Double> availsMap = null;
        this.log.debug("avail Enabled");
        this.log.debug("getting all nodeids of map (and submaps)");
        HashSet<Integer> nodeIds = new HashSet<Integer>();
        if (mapElements != null) {
            for (int i = 0; i < mapElements.length; ++i) {
                if (mapElements[i].isNode()) {
                    nodeIds.add(new Integer(mapElements[i].getId()));
                    continue;
                }
                nodeIds.addAll(this.getNodeidsOnElement(mapElements[i]));
            }
        }
        this.log.debug("all nodeids obtained");
        this.log.debug("Getting avails for nodes of map (" + nodeIds.size() + " nodes)");
        availsMap = this.getNodeAvailability(nodeIds);
        this.log.debug("Avails obtained");
        return availsMap;
    }

    private Map<Integer, Double> getNodeAvailability(Set<Integer> nodeIds) throws MapsException {
        GregorianCalendar cal = new GregorianCalendar();
        Date end = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date start = cal.getTime();
        if (nodeIds == null) {
            throw new IllegalArgumentException("Cannot take nodeIds null.");
        }
        if (start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        double avail = -1.0;
        int nodeid = 0;
        TreeMap<Integer, Double> retMap = new TreeMap<Integer, Double>();
        if (nodeIds.size() > 0) {
            Connection conn = this.createConnection();
            try {
                StringBuffer sb = new StringBuffer("select nodeid, getManagePercentAvailNodeWindow(nodeid, ?, ?)  from node where nodeid in (");
                Iterator<Integer> it = nodeIds.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
                PreparedStatement stmt = conn.prepareStatement(sb.toString());
                stmt.setTimestamp(1, new Timestamp(end.getTime()));
                stmt.setTimestamp(2, new Timestamp(start.getTime()));
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    nodeid = rs.getInt(1);
                    avail = rs.getDouble(2);
                    retMap.put(new Integer(nodeid), new Double(avail));
                }
            }
            catch (Exception e) {
                throw new MapsException(e);
            }
            finally {
                this.releaseConnection(conn);
            }
        }
        return retMap;
    }

    String getMapName(int id) throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT mapname FROM " + this.mapTable + " WHERE mapId = ?";
            PreparedStatement statement = conn.prepareStatement(sqlQuery);
            statement.setInt(1, id);
            ResultSet rs = statement.executeQuery();
            String label = null;
            if (rs.next()) {
                label = rs.getString(1);
            }
            rs.close();
            statement.close();
            String string = label;
            return string;
        }
        catch (Exception e) {
            this.log.error("Exception while getting name of map with mapid " + id);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public Vector<Integer> getDeletedNodes() throws MapsException {
        Connection conn = this.createConnection();
        try {
            String sqlQuery = "SELECT nodeid  FROM node where nodetype='D'";
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery("SELECT nodeid  FROM node where nodetype='D'");
            Vector<Integer> elements = new Vector<Integer>();
            while (rs.next()) {
                int nId = rs.getInt(1);
                elements.add(new Integer(nId));
            }
            rs.close();
            statement.close();
            Vector<Integer> vector = elements;
            return vector;
        }
        catch (Exception e) {
            this.log.error("Exception while getting deleted nodes");
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    @Override
    public Set<Integer> getNodeidsOnElement(DbElement elem) throws MapsException {
        HashSet<Integer> elementNodeIds = new HashSet<Integer>();
        if (elem.isNode()) {
            elementNodeIds.add(new Integer(elem.getId()));
        } else if (elem.isMap()) {
            DbElement[] elemMapElems;
            int curMapId = elem.getId();
            DbElement[] elemNodeElems = this.getNodeElementsOfMap(curMapId);
            if (elemNodeElems != null && elemNodeElems.length > 0) {
                for (int i = 0; i < elemNodeElems.length; ++i) {
                    elementNodeIds.add(new Integer(elemNodeElems[i].getId()));
                }
            }
            if ((elemMapElems = this.getMapElementsOfMap(curMapId)) != null && elemMapElems.length > 0) {
                for (int i = 0; i < elemMapElems.length; ++i) {
                    elementNodeIds.addAll(this.getNodeidsOnElement(elemMapElems[i]));
                }
            }
        }
        return elementNodeIds;
    }

    private Vector<DbMap> rs2MapVector(ResultSet rs) throws SQLException {
        Vector<DbMap> mapVec = null;
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                mapVec = new Vector<DbMap>();
                firstTime = false;
            }
            DbMap currMap = new DbMap();
            currMap.setAccessMode(rs.getString("mapAccess"));
            currMap.setBackground(rs.getString("mapBackGround"));
            currMap.setId(rs.getInt("mapId"));
            currMap.setName(rs.getString("mapName"));
            currMap.setOffsetX(rs.getInt("mapXOffset"));
            currMap.setOffsetY(rs.getInt("mapYOffset"));
            currMap.setOwner(rs.getString("mapOwner"));
            currMap.setScale(rs.getFloat("mapScale"));
            currMap.setType(rs.getString("mapType"));
            currMap.setWidth(rs.getInt("mapwidth"));
            currMap.setHeight(rs.getInt("mapheight"));
            currMap.setUserLastModifies(rs.getString("userLastModifies"));
            currMap.setCreateTime(rs.getTimestamp("mapCreateTime"));
            currMap.setLastModifiedTime(rs.getTimestamp("lastmodifiedtime"));
            currMap.setAsNew(false);
            mapVec.add(currMap);
        }
        return mapVec;
    }

    private Vector<VMapInfo> rs2MapMenuVector(ResultSet rs) throws SQLException {
        Vector<VMapInfo> mapVec = null;
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                mapVec = new Vector<VMapInfo>();
                firstTime = false;
            }
            VMapInfo currMap = new VMapInfo(rs.getInt("mapId"), rs.getString("mapName"), rs.getString("mapOwner"));
            mapVec.add(currMap);
        }
        return mapVec;
    }

    private VMapInfo rs2MapMenu(ResultSet rs) throws SQLException {
        VMapInfo map = null;
        if (rs.next()) {
            map = new VMapInfo(rs.getInt("mapId"), rs.getString("mapName"), rs.getString("mapOwner"));
        }
        return map;
    }

    private DbMap rs2Map(ResultSet rs) throws SQLException {
        DbMap map = null;
        if (rs.next()) {
            map = new DbMap();
            map.setAccessMode(rs.getString("mapAccess"));
            map.setBackground(rs.getString("mapBackGround"));
            map.setId(rs.getInt("mapId"));
            map.setName(rs.getString("mapName"));
            map.setOffsetX(rs.getInt("mapXOffset"));
            map.setOffsetY(rs.getInt("mapYOffset"));
            map.setOwner(rs.getString("mapOwner"));
            map.setGroup(rs.getString("mapGroup"));
            map.setScale(rs.getFloat("mapScale"));
            map.setType(rs.getString("mapType"));
            map.setWidth(rs.getInt("mapwidth"));
            map.setHeight(rs.getInt("mapheight"));
            map.setUserLastModifies(rs.getString("userLastModifies"));
            map.setCreateTime(rs.getTimestamp("mapCreateTime"));
            map.setLastModifiedTime(rs.getTimestamp("lastmodifiedtime"));
            map.setAsNew(false);
        }
        return map;
    }

    private DbElement rs2Element(ResultSet rs) throws SQLException, MapsException {
        DbElement element = null;
        if (rs.next()) {
            element = new DbElement();
            element.setMapId(rs.getInt("mapId"));
            element.setId(rs.getInt("elementId"));
            element.setType(rs.getString("elementType"));
            element.setLabel(rs.getString("elementLabel"));
            element.setIcon(rs.getString("elementIcon"));
            element.setX(rs.getInt("elementX"));
            element.setY(rs.getInt("elementY"));
        }
        return element;
    }

    private Vector<DbElement> rs2ElementVector(ResultSet rs) throws SQLException, MapsException {
        Vector<DbElement> vecElem = null;
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                vecElem = new Vector<DbElement>();
                firstTime = false;
            }
            DbElement currElem = new DbElement();
            currElem.setMapId(rs.getInt("mapId"));
            currElem.setId(rs.getInt("elementId"));
            currElem.setType(rs.getString("elementType"));
            currElem.setLabel(rs.getString("elementLabel"));
            currElem.setIcon(rs.getString("elementIcon"));
            currElem.setX(rs.getInt("elementX"));
            currElem.setY(rs.getInt("elementY"));
            vecElem.add(currElem);
        }
        return vecElem;
    }

    @Override
    public Set<LinkInfo> getLinksOnElements(Set<Integer> allnodes) throws MapsException {
        this.log.debug("getLinksOnElements " + allnodes);
        HashSet<LinkInfo> nodes = null;
        Connection conn = this.createConnection();
        try {
            LinkInfo link;
            Object element;
            int snmpifadminstatus;
            int snmpifoperstatus;
            long snmpifspeed;
            int snmpiftype;
            String status;
            int linktypeid;
            int parentifindex;
            int nodeparentid;
            int ifindex;
            int nodeid;
            int id;
            nodes = new HashSet<LinkInfo>();
            if (allnodes == null || allnodes.size() == 0) {
                HashSet<LinkInfo> hashSet = nodes;
                return hashSet;
            }
            String nodelist = "";
            Iterator<Integer> ite = allnodes.iterator();
            while (ite.hasNext()) {
                nodelist = nodelist + ite.next();
                if (!ite.hasNext()) continue;
                nodelist = nodelist + ",";
            }
            Statement stmt = conn.createStatement();
            String sql = "SELECT datalinkinterface.id, datalinkinterface.nodeid, ifindex,nodeparentid, parentifindex, status, linktypeid,snmpiftype,snmpifspeed,snmpifoperstatus,snmpifadminstatus FROM datalinkinterface left join snmpinterface on nodeparentid = snmpinterface.nodeid WHERE (datalinkinterface.nodeid IN (" + nodelist + ")" + " AND nodeparentid in (" + nodelist + ")) " + "AND status != 'D' and datalinkinterface.parentifindex = snmpinterface.snmpifindex";
            this.log.debug("getLinksOnElements: executing query:\n " + sql);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                id = -1;
                nodeid = -1;
                ifindex = -1;
                nodeparentid = -1;
                parentifindex = -1;
                linktypeid = -1;
                status = "U";
                snmpiftype = -1;
                snmpifspeed = -1L;
                snmpifoperstatus = -1;
                snmpifadminstatus = -1;
                element = new Integer(rs.getInt("id"));
                if (element != null) {
                    id = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("nodeid"))) != null) {
                    nodeid = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("ifindex"))) != null) {
                    ifindex = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("nodeparentid"))) != null) {
                    nodeparentid = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("parentifindex"))) != null) {
                    parentifindex = (Integer)element;
                }
                if ((element = new String(rs.getString("status"))) != null) {
                    status = (String)element;
                }
                if ((element = new Integer(rs.getInt("linktypeid"))) != null) {
                    linktypeid = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("snmpiftype"))) != null) {
                    snmpiftype = (Integer)element;
                }
                if ((element = new Long(rs.getLong("snmpifspeed"))) != null) {
                    snmpifspeed = (Long)element;
                }
                if ((element = new Integer(rs.getInt("snmpifoperstatus"))) != null) {
                    snmpifoperstatus = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("snmpifadminstatus"))) != null) {
                    snmpifadminstatus = (Integer)element;
                }
                this.log.debug("getLinksOnElements: id=" + id);
                link = new LinkInfo(id, nodeid, ifindex, nodeparentid, parentifindex, snmpiftype, snmpifspeed, snmpifoperstatus, snmpifadminstatus, status, linktypeid);
                nodes.add(link);
            }
            rs.close();
            sql = "SELECT datalinkinterface.id, datalinkinterface.nodeid, ifindex,nodeparentid, parentifindex, status, linktypeid, snmpiftype,snmpifspeed,snmpifoperstatus,snmpifadminstatus FROM datalinkinterface left join snmpinterface on datalinkinterface.nodeid = snmpinterface.nodeid WHERE (datalinkinterface.nodeid IN (" + nodelist + ")" + " AND nodeparentid in (" + nodelist + ")) " + "AND status != 'D' and datalinkinterface.ifindex = snmpinterface.snmpifindex";
            this.log.debug("getLinksOnElements: executing query:\n" + sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                id = -1;
                nodeid = -1;
                ifindex = -1;
                nodeparentid = -1;
                parentifindex = -1;
                linktypeid = -1;
                status = "U";
                snmpiftype = -1;
                snmpifspeed = -1L;
                snmpifoperstatus = -1;
                snmpifadminstatus = -1;
                element = new Integer(rs.getInt("id"));
                if (element != null) {
                    id = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("nodeid"))) != null) {
                    nodeid = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("ifindex"))) != null) {
                    ifindex = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("nodeparentid"))) != null) {
                    nodeparentid = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("parentifindex"))) != null) {
                    parentifindex = (Integer)element;
                }
                if ((element = new String(rs.getString("status"))) != null) {
                    status = (String)element;
                }
                if ((element = new Integer(rs.getInt("linktypeid"))) != null) {
                    linktypeid = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("snmpiftype"))) != null) {
                    snmpiftype = (Integer)element;
                }
                if ((element = new Long(rs.getLong("snmpifspeed"))) != null) {
                    snmpifspeed = (Long)element;
                }
                if ((element = new Integer(rs.getInt("snmpifoperstatus"))) != null) {
                    snmpifoperstatus = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("snmpifadminstatus"))) != null) {
                    snmpifadminstatus = (Integer)element;
                }
                this.log.debug("getLinksOnElements: id=" + id);
                link = new LinkInfo(id, nodeid, ifindex, nodeparentid, parentifindex, snmpiftype, snmpifspeed, snmpifoperstatus, snmpifadminstatus, status, linktypeid);
                nodes.add(link);
            }
            rs.close();
            sql = "SELECT id,nodeid, ifindex,nodeparentid, parentifindex, status, linktypeid FROM datalinkinterface WHERE (nodeid IN (" + nodelist + ")" + " AND nodeparentid in (" + nodelist + ")) " + "AND status != 'D'";
            this.log.debug("getLinksOnElements: executing query:\n" + sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                id = -1;
                nodeid = -1;
                ifindex = -1;
                nodeparentid = -1;
                parentifindex = -1;
                linktypeid = -1;
                status = "U";
                snmpiftype = -1;
                snmpifspeed = -1L;
                snmpifoperstatus = -1;
                snmpifadminstatus = -1;
                element = new Integer(rs.getInt("id"));
                if (element != null) {
                    id = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("nodeid"))) != null) {
                    nodeid = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("ifindex"))) != null) {
                    ifindex = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("nodeparentid"))) != null) {
                    nodeparentid = (Integer)element;
                }
                if ((element = new Integer(rs.getInt("parentifindex"))) != null) {
                    parentifindex = (Integer)element;
                }
                if ((element = new String(rs.getString("status"))) != null) {
                    status = (String)element;
                }
                if ((element = new Integer(rs.getInt("linktypeid"))) != null) {
                    linktypeid = (Integer)element;
                }
                this.log.debug("getLinksOnElements: id=" + id);
                link = new LinkInfo(id, nodeid, ifindex, nodeparentid, parentifindex, snmpiftype, snmpifspeed, snmpifoperstatus, snmpifadminstatus, status, linktypeid);
                nodes.add(link);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            this.log.error("Exception while getting links on elements " + allnodes, (Throwable)e);
            throw new MapsException(e);
        }
        finally {
            this.releaseConnection(conn);
        }
        return nodes;
    }

    @Override
    public Set<Integer> getNodeIdsBySource(String query) throws MapsException {
        if (query == null) {
            return this.getAllNodes();
        }
        HashSet<Integer> nodes = new HashSet<Integer>();
        Connection conn = this.createConnection();
        try {
            String sqlQuery = query;
            this.log.debug("Applying filters for source  '" + sqlQuery + "'");
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sqlQuery);
            while (rs.next()) {
                nodes.add(new Integer(rs.getInt(1)));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new MapsException("Exception while getting nodes by source label " + e);
        }
        finally {
            this.releaseConnection(conn);
        }
        return nodes;
    }

    private Set<Integer> getAllNodes() throws MapsException {
        Connection conn = this.createConnection();
        HashSet<Integer> nodes = new HashSet<Integer>();
        try {
            String sqlQuery = "select distinct nodeid from ipinterface";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sqlQuery);
            while (rs.next()) {
                nodes.add(new Integer(rs.getInt(1)));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new MapsException("Exception while getting all nodes " + e);
        }
        finally {
            this.releaseConnection(conn);
        }
        return nodes;
    }

    @Override
    public boolean isElementNotDeleted(int elementId, String type) throws MapsException {
        this.log.debug("isElementNotDeleted: elementId=" + elementId + " type= " + type);
        if (type.equals("M")) {
            this.log.debug("isElementNotDeleted: elementId=" + elementId + " type= " + type);
            return this.isMapInRow(elementId);
        }
        if (type.equals("N")) {
            this.log.debug("isElementNotDeleted: elementId=" + elementId + " type= " + type);
            return this.isNodeInRow(elementId);
        }
        return false;
    }

    private boolean isMapInRow(int mapId) throws MapsException {
        Connection conn = this.createConnection();
        boolean isThere = false;
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT mapid FROM map WHERE MAPID = ?");
            stmt.setInt(1, mapId);
            ResultSet rs = stmt.executeQuery();
            if (rs == null) {
                throw new IllegalArgumentException("rs parameter cannot be null");
            }
            isThere = !rs.next();
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new MapsException("Exception while getting mapid " + e);
        }
        finally {
            this.releaseConnection(conn);
        }
        this.log.debug("isMapInRow: elementId=" + mapId + "is There: " + isThere);
        return isThere;
    }

    private boolean isNodeInRow(int nodeId) throws MapsException {
        Connection conn = this.createConnection();
        boolean isThere = false;
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT nodeid FROM NODE WHERE NODEID = ?");
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            if (rs == null) {
                throw new IllegalArgumentException("rs parameter cannot be null");
            }
            isThere = !rs.next();
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new MapsException("Exception while getting nodeid " + e);
        }
        finally {
            this.releaseConnection(conn);
        }
        this.log.debug("isNodeInRow: elementId=" + nodeId + "is There: " + isThere);
        return isThere;
    }

    private String getLabel(String FQDN) {
        if (FQDN.indexOf(".") > 0) {
            return FQDN.substring(0, FQDN.indexOf("."));
        }
        return FQDN;
    }
}

