/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONSerializer;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VElementInfo;
import org.opennms.web.map.view.VLink;
import org.opennms.web.map.view.VMap;
import org.opennms.web.map.view.VMapInfo;
import org.opennms.web.map.view.VProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseAssembler {
    protected static String getRefreshResponse(VMap map) {
        HashMap<String, Collection<Object>> refreshResponseMap = new HashMap<String, Collection<Object>>();
        refreshResponseMap.put("elems", map.getElements().values());
        refreshResponseMap.put("links", map.getLinks());
        return JSONSerializer.toJSON(refreshResponseMap).toString();
    }

    protected static String getAddElementResponse(List<Integer> mapsWithLoopInfo, Collection<VElement> elems, Collection<VLink> links) {
        HashMap<String, Collection<Object>> addElementResponseMap = new HashMap<String, Collection<Object>>();
        addElementResponseMap.put("mapsWithLoop", mapsWithLoopInfo);
        addElementResponseMap.put("elems", elems);
        addElementResponseMap.put("links", links);
        return JSONSerializer.toJSON(addElementResponseMap).toString();
    }

    protected static String getDeleteElementsResponse(List<String> velemsids) {
        return JSONSerializer.toJSON(velemsids).toString();
    }

    protected static String getLoadNodesResponse(List<VElementInfo> elemInfos) {
        return JSONSerializer.toJSON(elemInfos).toString();
    }

    protected static String getLoadMapsResponse(List<VMapInfo> vmapinfos) {
        return JSONSerializer.toJSON(vmapinfos).toString();
    }

    protected static String getLoadDefaultMapResponse(VMapInfo vmapinfo) {
        return JSONSerializer.toJSON((Object)vmapinfo).toString();
    }

    protected static String getSaveMapResponse(VMap map) {
        HashMap<String, Object> saveMapResponse = new HashMap<String, Object>();
        saveMapResponse.put("id", map.getId());
        saveMapResponse.put("accessMode", map.getAccessMode());
        saveMapResponse.put("owner", map.getOwner());
        saveMapResponse.put("userLastModifies", map.getUserLastModifies());
        SimpleDateFormat formatter = new SimpleDateFormat("HH.mm.ss dd/MM/yy");
        Date now = new Date();
        if (map.getLastModifiedTime() != null) {
            saveMapResponse.put("lastModifiedTimeString", formatter.format(map.getLastModifiedTime()));
        } else {
            saveMapResponse.put("lastModifiedTimeString", formatter.format(now));
        }
        if (map.getCreateTime() != null) {
            saveMapResponse.put("createTimeString", formatter.format(map.getCreateTime()));
        } else {
            saveMapResponse.put("createTimeString", formatter.format(now));
        }
        return JSONSerializer.toJSON(saveMapResponse).toString();
    }

    protected static String getMapResponse(VMap map) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH.mm.ss dd/MM/yy");
        Date now = new Date();
        if (map.getLastModifiedTime() != null) {
            map.setLastModifiedTimeString(formatter.format(map.getLastModifiedTime()));
        } else {
            map.setLastModifiedTimeString(formatter.format(now));
        }
        if (map.getCreateTime() != null) {
            map.setCreateTimeString(formatter.format(map.getCreateTime()));
        } else {
            map.setCreateTimeString(formatter.format(now));
        }
        return JSONSerializer.toJSON((Object)map).toString();
    }

    protected static String getStartupResponse(VProperties initObj) throws Exception {
        return JSONSerializer.toJSON((Object)initObj).toString();
    }

    protected static String getLoadLabelMapResponse(Map<String, Set<Integer>> labelMap) {
        return JSONSerializer.toJSON(labelMap).toString();
    }

    protected static String getActionOKMapResponse(String action) {
        return action + "OK";
    }

    protected static String getMapErrorResponse(String action) {
        return action + "Failed";
    }
}

