/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class NewMapController
implements Controller {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        int mapWidth = WebSecurityUtils.safeParseInt((String)request.getParameter("MapWidth"));
        int mapHeight = WebSecurityUtils.safeParseInt((String)request.getParameter("MapHeight"));
        this.log.debug("Current mapWidth=" + mapWidth + " and MapHeight=" + mapHeight);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            this.log.info("New Map in admin mode: creating new map");
            VMap map = this.manager.newMap(request.getRemoteUser(), request.getRemoteUser(), mapWidth, mapHeight);
            bw.write(ResponseAssembler.getMapResponse(map));
        }
        catch (Exception e) {
            this.log.error("Error while creating new map for user:" + request.getRemoteUser(), (Throwable)e);
            bw.write(ResponseAssembler.getMapErrorResponse("admin/NewMap"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

