/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class DeleteElementsController
implements Controller {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        String action = request.getParameter("action");
        String elems = request.getParameter("elems");
        this.log.debug("Adding elements action:" + action + ", elems=" + elems);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            VMap map = this.manager.openMap();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Got map from manager " + map);
            }
            Integer[] elemeids = null;
            String type = "N";
            String[] mapids = elems.split(",");
            elemeids = new Integer[mapids.length];
            for (int i = 0; i < mapids.length; ++i) {
                elemeids[i] = new Integer(mapids[i]);
            }
            boolean actionfound = false;
            if (action.equals("DeleteNodes")) {
                actionfound = true;
            }
            if (action.equals("DeleteMaps")) {
                actionfound = true;
                type = "M";
            }
            ArrayList<String> velemsids = new ArrayList<String>();
            if (actionfound) {
                for (int i = 0; i < elemeids.length; ++i) {
                    int elemId = elemeids[i];
                    if (!map.containsElement(elemId, type)) continue;
                    map.removeLinksOnElementList(elemId, type);
                    VElement ve = map.removeElement(elemId, type);
                    velemsids.add(ve.getId() + ve.getType());
                }
            }
            bw.write(ResponseAssembler.getDeleteElementsResponse(velemsids));
        }
        catch (Exception e) {
            this.log.error("Error while adding nodes for action: " + action, (Throwable)e);
            bw.write(ResponseAssembler.getMapErrorResponse(action));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

