/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CatFactory;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.web.WebSecurityUtils;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.element.Node;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class AddNodesController
implements Controller {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        String action = request.getParameter("action");
        String elems = request.getParameter("elems");
        this.log.debug("Adding Nodes action:" + action + ", elems=" + elems);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            int i;
            Integer[] nodeids = null;
            boolean actionfound = false;
            if (action.equals("admin/AddNodes")) {
                this.log.debug("Adding nodes by id: " + elems);
                actionfound = true;
                String[] snodeids = elems.split(",");
                nodeids = new Integer[snodeids.length];
                for (i = 0; i < snodeids.length; ++i) {
                    nodeids[i] = new Integer(snodeids[i]);
                }
            }
            if (action.equals("AddNodesByCategory")) {
                this.log.debug("Adding nodes by category: " + elems);
                actionfound = true;
                String categoryName = elems;
                CategoryFactory.init();
                CatFactory cf = CategoryFactory.getInstance();
                String rule = cf.getEffectiveRule(categoryName);
                List nodeIPs = FilterDaoFactory.getInstance().getIPList(rule);
                this.log.debug("ips found: " + nodeIPs.toString());
                nodeids = new Integer[nodeIPs.size()];
                for (int i2 = 0; i2 < nodeIPs.size(); ++i2) {
                    String nodeIp = (String)nodeIPs.get(i2);
                    List<Integer> ids = NetworkElementFactory.getNodeIdsWithIpLike(nodeIp);
                    this.log.debug("Ids by ipaddress " + nodeIp + ": " + ids);
                    nodeids[i2] = ids.get(0);
                }
            }
            if (action.equals("AddNodesByLabel")) {
                this.log.debug("Adding nodes by label: " + elems);
                actionfound = true;
                Node[] nodes = NetworkElementFactory.getNodesLike(elems);
                nodeids = new Integer[nodes.length];
                for (i = 0; i < nodes.length; ++i) {
                    nodeids[i] = new Integer(nodes[i].getNodeId());
                }
            }
            if (action.equals("AddRange")) {
                this.log.debug("Adding nodes by range: " + elems);
                actionfound = true;
                nodeids = NetworkElementFactory.getNodeIdsWithIpLike(elems).toArray(new Integer[0]);
            }
            if (action.equals("AddNodesNeig")) {
                this.log.debug("Adding nodes neighbor of:" + elems);
                actionfound = true;
                nodeids = NetworkElementFactory.getLinkedNodeIdOnNode(WebSecurityUtils.safeParseInt((String)elems)).toArray(new Integer[0]);
            }
            if (action.equals("AddNodesWithNeig")) {
                this.log.debug("Adding nodes with neighbor of:" + elems);
                actionfound = true;
                Set<Integer> linkednodeids = NetworkElementFactory.getLinkedNodeIdOnNode(WebSecurityUtils.safeParseInt((String)elems));
                linkednodeids.add(new Integer(elems));
                nodeids = linkednodeids.toArray(new Integer[linkednodeids.size()]);
            }
            VMap map = this.manager.openMap();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Got map from manager " + map);
            }
            ArrayList<VElement> velems = new ArrayList<VElement>();
            if (actionfound) {
                this.log.debug("Before Checking map contains elems");
                for (int i3 = 0; i3 < nodeids.length; ++i3) {
                    int elemId = nodeids[i3];
                    if (map.containsElement(elemId, "N")) {
                        this.log.debug("Action: " + action + " . Map Contains Element: " + elemId + "N");
                        continue;
                    }
                    velems.add(this.manager.newElement(map.getId(), elemId, "N"));
                }
                map = this.manager.addElements(map, velems);
                this.log.debug("After getting/adding links");
                bw.write(ResponseAssembler.getAddElementResponse(null, velems, map.getLinks()));
            }
        }
        catch (Exception e) {
            this.log.error("Error while adding nodes for action: " + action, (Throwable)e);
            bw.write(ResponseAssembler.getMapErrorResponse(action));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

