/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VElement;
import org.opennms.web.map.view.VMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class AddMapsController
implements Controller {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        String elems = request.getParameter("elems");
        this.log.debug("Adding Maps: elems=" + elems);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        try {
            VMap map = this.manager.openMap();
            ArrayList<VElement> velems = new ArrayList<VElement>();
            ArrayList<Integer> mapsWithLoop = new ArrayList<Integer>();
            this.log.debug("Got map from manager " + map);
            this.log.debug("Adding maps by id: " + elems);
            String[] smapids = elems.split(",");
            for (int i = 0; i < smapids.length; ++i) {
                Integer id = new Integer(smapids[i]);
                if (map.containsElement(id, "M")) {
                    this.log.debug(" Map Contains Element: " + id + "M");
                    continue;
                }
                boolean foundLoop = this.manager.foundLoopOnMaps(map, id);
                if (foundLoop) {
                    mapsWithLoop.add(id);
                    continue;
                }
                velems.add(this.manager.newElement(map.getId(), id, "M"));
            }
            map = this.manager.addElements(map, velems);
            bw.write(ResponseAssembler.getAddElementResponse(mapsWithLoop, velems, map.getLinks()));
        }
        catch (Exception e) {
            this.log.error("Error while adding Maps: ", (Throwable)e);
            bw.write(ResponseAssembler.getMapErrorResponse("admin/AddMaps"));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

