/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.group;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.config.groups.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebGroup {
    private String m_name;
    private String m_comments;
    private String m_defaultMap = "";
    private List<String> m_dutySchedules = new ArrayList<String>();
    private List<String> m_authorizedCategories = new ArrayList<String>();
    private List<String> m_users = new ArrayList<String>();

    public WebGroup() {
    }

    public WebGroup(Group group, List<String> authorizedCategories) {
        this.m_name = group.getName();
        this.m_comments = group.getComments();
        if (group.getDefaultMap() != null) {
            this.m_defaultMap = group.getDefaultMap();
        }
        this.m_dutySchedules.addAll(group.getDutyScheduleCollection());
        this.m_users.addAll(group.getUserCollection());
        this.m_authorizedCategories.addAll(authorizedCategories);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getComments() {
        return this.m_comments;
    }

    public void setComments(String comments) {
        this.m_comments = comments;
    }

    public List<String> getDutySchedules() {
        return this.m_dutySchedules;
    }

    public void setDutySchedules(List<String> dutySchedules) {
        this.m_dutySchedules = dutySchedules;
    }

    public void addDutySchedule(String dutySchedule) {
        this.m_dutySchedules.add(dutySchedule);
    }

    public List<String> getAuthorizedCategories() {
        return this.m_authorizedCategories;
    }

    public void setAuthorizedCategories(List<String> authorizedCategories) {
        this.m_authorizedCategories = authorizedCategories;
    }

    public List<String> getUsers() {
        return this.m_users;
    }

    public void setUsers(List<String> users) {
        this.m_users = users;
    }

    public List<String> getUnauthorizedCategories(List<String> allCategories) {
        ArrayList<String> unauthorizedCategories = new ArrayList<String>(allCategories);
        unauthorizedCategories.removeAll(this.m_authorizedCategories);
        return unauthorizedCategories;
    }

    public List<String> getRemainingUsers(List<String> allUsers) {
        ArrayList<String> remainingUsers = new ArrayList<String>(allUsers);
        remainingUsers.removeAll(this.m_users);
        return remainingUsers;
    }

    public String getDefaultMap() {
        return this.m_defaultMap;
    }

    public void setDefaultMap(String defaultMap) {
        this.m_defaultMap = defaultMap;
    }
}

