/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.graph;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.web.graph.Graph;
import org.opennms.web.graph.RelativeTimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphResults {
    private static final String[] s_months;
    private static final Map<Integer, String> s_monthMap;
    private static final String[] s_hours;
    private static final Map<Integer, String> s_hourMap;
    private String[] m_reports;
    private Date m_start;
    private Date m_end;
    private String m_relativeTime;
    private RelativeTimePeriod[] m_relativeTimePeriods;
    private List<GraphResultSet> m_graphResultSets = new LinkedList<GraphResultSet>();
    private int m_graphTopOffsetWithText;
    private int m_graphLeftOffset;
    private int m_graphRightOffset;

    public void setStart(Date start) {
        this.m_start = start;
    }

    public Date getStart() {
        return this.m_start;
    }

    public BeanFriendlyCalendar getStartCalendar() {
        return new BeanFriendlyCalendar(this.m_start);
    }

    public void setEnd(Date end) {
        this.m_end = end;
    }

    public Date getEnd() {
        return this.m_end;
    }

    public BeanFriendlyCalendar getEndCalendar() {
        return new BeanFriendlyCalendar(this.m_end);
    }

    public void setRelativeTime(String relativeTime) {
        this.m_relativeTime = relativeTime;
    }

    public String getRelativeTime() {
        return this.m_relativeTime;
    }

    public void setRelativeTimePeriods(RelativeTimePeriod[] relativeTimePeriods) {
        this.m_relativeTimePeriods = relativeTimePeriods;
    }

    public RelativeTimePeriod[] getRelativeTimePeriods() {
        return this.m_relativeTimePeriods;
    }

    public static String[] getMonths() {
        return s_months;
    }

    public Map<Integer, String> getMonthMap() {
        return s_monthMap;
    }

    public static String[] getHours() {
        return s_hours;
    }

    public Map<Integer, String> getHourMap() {
        return s_hourMap;
    }

    public void addGraphResultSet(GraphResultSet resultSet) {
        this.m_graphResultSets.add(resultSet);
    }

    public List<GraphResultSet> getGraphResultSets() {
        return this.m_graphResultSets;
    }

    public String[] getReports() {
        return this.m_reports;
    }

    public void setReports(String[] reports) {
        this.m_reports = reports;
    }

    public int getGraphLeftOffset() {
        return this.m_graphLeftOffset;
    }

    public void setGraphLeftOffset(int graphLeftOffset) {
        this.m_graphLeftOffset = graphLeftOffset;
    }

    public int getGraphRightOffset() {
        return this.m_graphRightOffset;
    }

    public void setGraphRightOffset(int graphRightOffset) {
        this.m_graphRightOffset = graphRightOffset;
    }

    public int getGraphTopOffsetWithText() {
        return this.m_graphTopOffsetWithText;
    }

    public void setGraphTopOffsetWithText(int graphTopOffsetWithText) {
        this.m_graphTopOffsetWithText = graphTopOffsetWithText;
    }

    static {
        int i;
        s_months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        s_monthMap = new LinkedHashMap<Integer, String>();
        for (i = 0; i < s_months.length; ++i) {
            s_monthMap.put(i, s_months[i]);
        }
        s_hours = new String[24];
        for (i = 0; i < s_hours.length; ++i) {
            int hour = i % 12;
            if (hour == 0) {
                hour = 12;
            }
            GraphResults.s_hours[i] = hour + " " + (i < 12 ? "AM" : "PM");
        }
        s_hourMap = new LinkedHashMap<Integer, String>();
        for (i = 0; i < s_hours.length; ++i) {
            s_hourMap.put(i, s_hours[i]);
        }
    }

    public class BeanFriendlyCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -4145668894553732167L;

        public BeanFriendlyCalendar(Date date) {
            this.setTime(date);
        }

        public int getYear() {
            return this.get(1);
        }

        public int getMonth() {
            return this.get(2);
        }

        public int getDate() {
            return this.get(5);
        }

        public int getHourOfDay() {
            return this.get(11);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GraphResultSet {
        private List<Graph> m_graphs = null;
        private OnmsResource m_resource;

        public void setResource(OnmsResource resource) {
            this.m_resource = resource;
        }

        public OnmsResource getResource() {
            return this.m_resource;
        }

        public List<Graph> getGraphs() {
            return this.m_graphs;
        }

        public void setGraphs(List<Graph> graphs) {
            this.m_graphs = graphs;
        }
    }
}

