/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.filter.SQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubstringFilter
extends OneArgFilter<String> {
    public SubstringFilter(String filterType, String fieldName, String propertyName, String value) {
        super(filterType, SQLType.STRING, fieldName, propertyName, value);
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.ilike((String)this.getPropertyName(), (String)((String)this.getValue()), (MatchMode)MatchMode.ANYWHERE);
    }

    @Override
    public String getSQLTemplate() {
        return " " + this.getSQLFieldName() + " ILIKE %s ";
    }

    @Override
    public String getBoundValue(String value) {
        return '%' + value + '%';
    }

    @Override
    public String formatValue(String value) {
        return super.formatValue('%' + value + '%');
    }
}

