/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import org.hibernate.Hibernate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.filter.SQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IPLikeFilter
extends OneArgFilter<String> {
    private static final Type STRING_TYPE = new StringType();

    public IPLikeFilter(String filterType, String fieldName, String propertyName, String ipLikePattern) {
        super(filterType, SQLType.STRING, fieldName, propertyName, ipLikePattern);
    }

    @Override
    public String getSQLTemplate() {
        return " IPLIKE(" + this.getSQLFieldName() + ", %s) ";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.sqlRestriction((String)("iplike( {alias}." + this.getPropertyName() + ", ?)"), this.getValue(), (Type)Hibernate.STRING);
    }
}

