/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.criterion.Criterion;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.web.filter.Filter;

public abstract class ConditionalFilter
implements Filter {
    public static final String TYPE = "conditionalFilter";
    private String m_conditionType;
    private Filter[] m_filters;

    public ConditionalFilter(String conditionType, Filter ... filters) {
        if (filters.length == 0) {
            throw new IllegalArgumentException("You must pass at least one filter");
        }
        this.m_conditionType = conditionType;
        this.m_filters = filters;
    }

    public Filter[] getFilters() {
        return this.m_filters;
    }

    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        int parametersBound = 0;
        for (Filter mFilter : this.m_filters) {
            parametersBound += mFilter.bindParam(ps, parameterIndex + parametersBound);
        }
        return parametersBound;
    }

    public String getDescription() {
        if (this.m_filters.length == 1) {
            return this.m_filters[0].getDescription();
        }
        StringBuilder buf = new StringBuilder(TYPE);
        buf.append("=");
        buf.append(this.m_conditionType);
        for (Filter filter : this.m_filters) {
            buf.append('(');
            buf.append(filter.getDescription());
            buf.append(')');
        }
        return buf.toString();
    }

    public String getParamSql() {
        if (this.m_filters.length == 1) {
            return this.m_filters[0].getParamSql();
        }
        StringBuilder buf = new StringBuilder("( ");
        for (int i = 0; i < this.m_filters.length; ++i) {
            if (i != 0) {
                buf.append(this.m_conditionType);
                buf.append(" ");
            }
            buf.append(this.m_filters[i].getParamSql());
        }
        buf.append(") ");
        return buf.toString();
    }

    public String getSql() {
        if (this.m_filters.length == 1) {
            return this.m_filters[0].getSql();
        }
        StringBuilder buf = new StringBuilder("( ");
        for (int i = 0; i < this.m_filters.length; ++i) {
            if (i != 0) {
                buf.append(this.m_conditionType);
                buf.append(" ");
            }
            buf.append(this.m_filters[i].getSql());
        }
        buf.append(") ");
        return buf.toString();
    }

    public String getTextDescription() {
        if (this.m_filters.length == 1) {
            return this.m_filters[0].getTextDescription();
        }
        StringBuilder buf = new StringBuilder("( ");
        for (int i = 0; i < this.m_filters.length; ++i) {
            if (i != 0) {
                buf.append(this.m_conditionType);
                buf.append(" ");
            }
            buf.append(this.m_filters[i].getTextDescription());
        }
        buf.append(")");
        return buf.toString();
    }

    public void applyCriteria(OnmsCriteria criteria) {
        criteria.add(this.getCriterion());
    }

    public abstract Criterion getCriterion();

    public String toString() {
        return new ToStringBuilder((Object)this).append("description", (Object)this.getDescription()).append("text description", (Object)this.getTextDescription()).toString();
    }
}

